/*!
 * Javascripts used in the theme
 *
 * @author Am!n <info@dornaweb.com>
 * @copyright Dornaweb.com allrights reserved
 * @package Source Iran theme
*/
(function(html){html.className = html.className.replace(/\bno-js\b/,'js')})(document.documentElement);

/*!
 * jQuery outerHTML
 */
jQuery.fn.outerHTML = function(s) {
	return s ? this.before(s).remove() : jQuery("<p>").append(this.eq(0).clone()).html();
};

/*!
 * Animate.CSS
 */
jQuery.fn.extend({
    animateCss: function (animationName) {
        var animationEnd = 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend';
        $(this).addClass('animated ' + animationName).on(animationEnd, function() {
            $(this).removeClass('animated ' + animationName);
        });
    }
});

/*!
 * jQuery Strip tags
 * Strips html tags from a string
 *
 * @author Am!n <www.dornaweb.com>
 */
jQuery.extend({
	stripTags : function(s) {
		return s ? s.replace(/(<([^>]+)>)/ig,"") : "";
	}
});

/*!
 * Dumpit - shortened console.log()
 * Good for debuging
 *
 * @author Am!n <www.dornaweb.com>
 */
function dumpit( s ) {
	console.log(s);
}

(function($) {
	$(function(){
		/**
		* main slider instance
		*/
		var main_slider = new Swiper('#main_slider', {
			pagination: '.main-slider-pagination',
			paginationClickable: true,
			spaceBetween: 2,
			rtl: true,
            autoplay: 5000,
			loop: true,
            effect: 'fade',
            fade: {
                crossFade: true
            },
			grabCursor: true,
			paginationBulletRender: function (swiper, index, className) {
				var html = '<span class="' + className + '"></span>';

				if( ( index + 1 ) === swiper.slides.length ){
					html += '<span class="curve-rounds-right"></span><span class="curve-rounds-left"></span>';
				}

				return html;
			}
		});

		/**
		* certificates slider instance
		*/
		var cert_slider = new Swiper('#certificates_slider', {
			pagination: '.swiper-pagination',
            paginationClickable: true,
			slidesPerView: 3,
			slidesPerGroup: 3,
			spaceBetween: 11,
			rtl: true,
			grabCursor: true
		});

	});
	/**
	 * Top navigation
	 */
	$(function(){
		function topMenuHandler(){};

		topMenuHandler.prototype.showUp = function ( link ) {
			if( link.hasClass('active') ) {
				this.disapear();
			} else {
				$('.top-nav-links a').removeClass('active');
				$('.top-menu-tab-box').removeClass('opened');
				link.addClass('active');
				$('.site-header .head-top').addClass('menu-open');
				$( link.data('target') ).addClass('opened');
			}
		};

		topMenuHandler.prototype.disapear = function () {
			$('.top-nav-links a').removeClass('active');
			$('.site-header .head-top').removeClass('menu-open');
			$('.top-menu-tab-box').removeClass('opened');
		};

		var topNav = new topMenuHandler();

		$('.top-nav-links a').click(function(e){
			e.preventDefault();

			topNav.showUp( $(this) );
		});

		$('.top-menu-tab-box .close-btn').click(function(){
			topNav.disapear()
		});
	});

	/*!
	 * Tab Boxes by dornaweb
	 * @author Am!n - http://www.dornaweb.com
	 * @version 1.2.2
	 */
	$(".tab-boxes").each(function() {
		var tabs = $(this);

		$("ul.tabs li",tabs).each(function() {
			if( $(this).hasClass("active") ) {

				/** Ajax load if not loaded already **/
				if( $(this).data("ajax-id") && $( $(this).attr("data-target") ).length === 0 ) {
					var ajax_id = $(this).data("ajax-id");

					$.ajax({
						method  : "GET",
						url     : ajax_url,
						data    : { action : "load_news_tab", newsid: ajax_id },
						success : function( msg ) {
							tabs.find(".tab-contents").append(msg);
						}
					});
				}

				/** Normal load **/
				else{
					$( $(this).attr("data-target") ).show();
				}
			}

			else {
				$( $(this).attr("data-target") ).hide();
			}
		});

		$("ul.tabs li:not('.exclude')",tabs).click( function() {
			var tab = $(this);
			var tabtar = tab.attr("data-target");

			if( !tab.hasClass("active") ) {
				$("ul.tabs li",tabs).removeClass("active");
				tab.addClass("active");
				$(".tab-content",tabs).hide();

				/** Ajax load **/
				if( tab.data("ajax-id") && $(tabtar).length === 0 ) {
					var ajax_id = tab.data("ajax-id");

					$.ajax({
						method  : "GET",
						url     : ajax_url,
						data    : { action : "load_news_tab", newsid: ajax_id },
						success : function( msg ) {
							tabs.find(".tab-contents").append(msg);
						}
					});
				}

				/** Normal load **/
				else {
					$(tabtar).fadeIn("medium");
				}
			}
		});
	});

	/**
	 * Canvas stuff
	 */
	$( function(){
	/*	var canvas = document.getElementById('main_slideshow_canvas');
		var ctx = canvas.getContext('2d');

		ctx.fillStyle = 'rgba(255,255,255,0.5)';
		ctx.fillRect(0, 0, canvas.width, canvas.height);

		console.log( ctx );*/
	});

	/**
	 * Fading text
	 *
	 */
	$('.fading-text .more').click(function(){
		$(this).toggleClass('trans-rotate-270 trans-rotate-90');
		$(this).parents('.fading-text').toggleClass('opened');
	});

	/*!
	* News Ticker instance
	*/
	$('#site-news-show').dwTicker({
		tickerData: "#site-news-list",
		interval: 8000
	});

	/**
	 * Fixing heights
	 */
	$(window).on('load resize', function(){
		if( $(window).width() > 767 ){
			$('[data-fixheight]').each(function(){
				var equalevants = $(this).data('fixheight');
				var maxHeight = Math.max.apply( null, $('[data-fixheight='+ equalevants +']').map(function () { return $(this).outerHeight(); }).get() );

				$('[data-fixheight='+ equalevants +']').css('height', maxHeight +'px');

			});
		}
	});

	$(document).ready(function() {
		$('select.nice-select-instance').niceSelect();
	});

	/**
	 * FAQ stuff
	 */
	$('.faq-questions ul li .question').click(function(){
		$(this).toggleClass('opened');
		$(this).parent().find('.answer').slideToggle('fast');
	});

	/**
	 * Custom input fields
	 */
	$(function(){
		$('.dw-ct-field').each(function(){
			if( $(this).val() !== '' ){
				$(this).addClass('editing');
			}
		});

		$('.dw-ct-field').on({
			focus: function(){
				$(this).addClass('editing');
			},
			blur: function(){
				if( $(this).val() === '' ){
					$(this).removeClass('editing');
				}
			}
		});

		$('.dw-ct-field + .placeholder').click(function(){
			$(this).parent().find('input').focus();
		});
	});
	$(document).on('opening', '.remodal', function () {
		$('.remodal p').niceScroll({
			zIndex: 9999999999,
			background:"#d7e7e4",
			cursorcolor:"#ff3f1a",
			cursorwidth:"4px",
			cursorborderradius:"0px",
			cursorborder: "0px",
			railalign: "left",
			autohidemode: false
		});
	});
	
  $("#menures").mmenu();
})(jQuery);









var TxtRotate = function(el, toRotate, period) {
  this.toRotate = toRotate;
  this.el = el;
  this.loopNum = 0;
  this.period = parseInt(period, 10) || 2000;
  this.txt = '';
  this.tick();
  this.isDeleting = false;
};

TxtRotate.prototype.tick = function() {
  var i = this.loopNum % this.toRotate.length;
  var fullTxt = this.toRotate[i];

  if (this.isDeleting) {
    this.txt = fullTxt.substring(0, this.txt.length - 1);
  } else {
    this.txt = fullTxt.substring(0, this.txt.length + 1);
  }

  this.el.innerHTML = '<span class="wrap">'+this.txt+'</span>';

  var that = this;
  var delta = 300 - Math.random() * 100;

  if (this.isDeleting) { delta /= 2; }

  if (!this.isDeleting && this.txt === fullTxt) {
    delta = this.period;
    this.isDeleting = true;
  } else if (this.isDeleting && this.txt === '') {
    this.isDeleting = false;
    this.loopNum++;
    delta = 500;
  }

  setTimeout(function() {
    that.tick();
  }, delta);
};

window.onload = function() {
  var elements = document.getElementsByClassName('txt-rotate');
  for (var i=0; i<elements.length; i++) {
    var toRotate = elements[i].getAttribute('data-rotate');
    var period = elements[i].getAttribute('data-period');
    if (toRotate) {
      new TxtRotate(elements[i], JSON.parse(toRotate), period);
    }
  }
  // INJECT CSS
  var css = document.createElement("style");
  css.type = "text/css";
  css.innerHTML = ".txt-rotate > .wrap { border-left: 0.08em solid #666 }";
  document.body.appendChild(css);
};
