<?php define("_VALID_PHP", true); define("_WOJO", true); require_once ("../../../init.php"); ?>
<html>
<head>
<meta charset="UTF-8">
</head>
<body>
<?php

/**
* PayStar IPN
*
* @package Digital Downloads Pro
* @author paystar.ir
* @copyright 2020
*/

$sesid = $_GET['s'];
$user_id = $_GET['u'];

$user = Db::run()->first(Users::mTable, null, array("id" => intval($user_id)));
$cart = Product::getCartContentIpn($sesid);
$totals = Product::getCartTotal($sesid);

$amount = $gross = $totals->grand;
if (App::Core()->currency != "IRR") $amount = $amount * 10;

$paystar = Db::run()->first("gateways", array("extra"), array("name" => "paystar"));
require_once(dirname(__DIR__) . '/paystar_payment_helper.class.php');
$p = new PayStar_Payment_Helper($paystar->extra);
$r = $p->paymentVerify(array_merge($_POST, array('amount' => intval(ceil($amount)))));
if ($r)
{
	$tax = Content::calculateTax();
	$amount = (($totals->tax > 0) ? $totals->grand : $tax * $totals->grand + $totals->grand);
	$items = array();
	$cdkey = array();
	if ($cart)
	{
		foreach ($cart as $k => $crow)
		{
			$key = Db::run()->getValue(Product::cdTable, "cdkey", "product_id", $crow->id);
			$data = array(
				'user_id' => $user->id,
				'product_id' => $crow->id,
				'txn_id' => $p->txn_id,
				'tax' => Validator::sanitize($crow->total * $tax, "float"),
				'amount' => Validator::sanitize($crow->total, "float"),
				'total' => Validator::sanitize(($totals->tax > 0) ? $totals->tax : $tax * $crow->total + $crow->total, "float"),
				'coupon' => $crow->coupon,
				'cdkey' => ($key) ? $key : "",
				'pp' => "PayStar",
				'ip' => Url::getIP(),
				'file_date' => time(),
				'currency' => strtoupper(App::Core()->currency),
				'status' => 1,
				);
			$items[$k]['title'] = $crow->title;
			$items[$k]['qty'] = 1;
			$items[$k]['price'] = $crow->total;
			$items[$k]['cdkey'] = $data['cdkey'];
			$cdkey[] = $data['cdkey'];
			Db::run()->insert(Product::xTable, $data);
			if($key)
			{
				Db::run()->delete(Product::cdTable, array("cdkey" => $data['cdkey']));
			}
		}
	}
	$xdata = array(
			'invoice_id' => substr(time(), 5),
			'transaction_id' => $p->txn_id,
			'user_id' => $user->id,
			'items' => json_encode($items),
			'coupon' => $totals->discount,
			'tax' => Utility::formatNumber(($totals->subtotal - $totals->discount) * $tax),
			'subtotal' => $totals->subtotal,
			'grand' => $amount,
			'currency' => strtoupper(App::Core()->currency),
		);
	Db::run()->insert(Product::ivTable, $xdata);
	$mailer = Mailer::sendMail();
	$tpl = Db::run()->first(Content::eTable, array("body", "subject"), array('typeid' => 'payComplete'));
	$core = App::Core();
	$body = str_replace(array('[LOGO]', '[CEMAIL]', '[COMPANY]', '[DATE]', '[SITEURL]', '[NAME]', '[TYPE]', '[ITEMNAME]', '[PRICE]', '[STATUS]', '[PP]', '[IP]', '[FB]', '[TW]'), 
		array(Utility::getLogo(), $core->site_email, $core->company, date('Y'), SITEURL, App::Auth()->name, Lang::$word->PRD_PRODUCT, implode(", ", array_column($cart, "title")), $amount, "Completed", "PayStar", Url::getIP(), $core->social->facebook, $core->social->twitter), 
		$tpl->body);
	$msg = Swift_Message::newInstance()->setSubject($tpl->subject)->setTo(array($core->site_email => $core->company))->setFrom(array($user->email => $user->fname . ' ' . $user->lname))->setBody($body, 'text/html');
	$mailer->send($msg);
	Db::run()->delete(Product::cxTable, array("user_id" => $sesid));
	/*
	require_once (BASEPATH . "lib/class_mailer.php");
	$row2 = $core->getRowById("email_templates", 5);
	$user = $core->getRowById("users", $user_id);
	$body = str_replace(array('[USERNAME]', '[STATUS]', '[TOTAL]', '[PP]', '[IP]'), array($user->username, "Completed", $core->formatMoney($gross), "PayStar", $_SERVER['REMOTE_ADDR']), $row2->body);
	$newbody = cleanOut($body);
	$mailer = Mailer::sendMail();
	$message = Swift_Message::newInstance()->setSubject($row2->subject)->setTo(array($core->site_email => $core->site_name))->setFrom(array($core->site_email => $core->site_name))->setBody($newbody, 'text/html');
	$mailer->send($message);
	$row3 = $core->getRowById("email_templates", 8);
	$val = '<table border="0" cellpadding="4" cellspacing="2">';
	$val .= '
	<thead>
	<tr>
	<td width="20"><strong>#</strong></td>
	<td><strong>Product Name</strong></td>
	<td><strong>Product Price</strong></td>
	<td><strong>Quantity</strong></td>
	<td><strong>Total Price</strong></td>
	</tr>
	</thead>
	<tbody>';
	$i = 0;
	foreach ($cart as $ccrow)
	{
		$i++;
		$val .= '
		<tr>
		<td style="border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed">' . $i . '.</td>
		<td style="border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed">' . sanitize($ccrow->title, 30, false) . '</td>
		<td style="border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed">' . $core->formatMoney($ccrow->price) . '</td>
		<td align="center" style="border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed">' . $ccrow->total . '</td>
		<td align="right" style="border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed">' . $core->formatMoney($ccrow->total * $ccrow->price) . '</td>
		</tr>';
	}
	unset($ccrow);
	$val .= '<tr><td colspan="4" align="right" valign="top" style="border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed"><strong>';
	$val .= 'Sub Total:<br /></strong></td><td align="right" valign="top" style="border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed"><strong>';
	$val .= $core->formatMoney($gross) . '<br /></strong>';
	$val .= ' </td>
	</tr>
	<tr>
	<td colspan="4" align="right" valign="top"><strong style="color:#F00">Grand Total:</strong></td>
	<td align="right" valign="top"><strong style="color:#F00">' . $core->formatMoney($gross) . '</strong></td>
	</tr>
	</tbody>
	</table>';
	$body3 = str_replace(array('[USERNAME]', '[ITEMS]', '[SITENAME]', '[URL]'), array($user->username, $val, $core->site_url, $core->site_name), $row3->body);
	$newbody2 = cleanOut($body3);
	$mailer2 = Mailer::sendMail();
	$message2 = Swift_Message :: newInstance()->setSubject($row3->subject)->setTo(array($user->email => $user->username))->setFrom(array($core->site_email => $core->site_name))->setBody($newbody2, 'text/html');
	$mailer2->send($message2);
	$db->delete("cart", "user_id='" . $sesid . "'");
	$db->delete("extras", "user_id='" . $sesid . "'");
	$db->delete("recent", "user_id='" . $sesid . "'");
	*/
	echo '<p class="msgOk" style="font-family:tahoma; direction:rtl; text-align:right" >عمليات پرداخت با موفقيت به پايان رسيد ،&nbsp;شماره رسيد پرداخت : ' . $p->txn_id . '</p>';
}
else
{
	echo '<p class="msgError" style="font-family:tahoma; direction:rtl; text-align:right" >خطا در پردازش عملیات پرداخت ، نتیجه پرداخت : ' . $p->error . ' !</p>';
}

echo '<div class="wrap" style="float:right">  <h1><span><a href="' . Url::url("/dashboard") . '" class="button-alt-sml" style="font-family:tahoma; direction:rtl; text-align:right; font-size:8pt" >بازگشت به صفحه حساب کاربري</a></span></h1>';

?>
</body>
</html>