<?php

/**
* PayStar Form
*
* @package Digital Downloads Pro
* @author paystar.ir
* @copyright 2020
*/

$amount = $this->cart->totalprice;
if (App::Core()->currency != "IRR") $amount = $amount * 10;
require_once(dirname(__FILE__) . '/paystar_payment_helper.class.php');
$p = new PayStar_Payment_Helper($this->gateway->extra);
$r = $p->paymentRequest(array(
		'amount'      => intval(ceil($amount)),
		'order_id'    => time(),
		'name'        => App::Auth()->username,
		'mail'        => App::Auth()->email,
		'description' => $this->row->title,
		'callback'    => SITEURL.'/gateways/'.$this->gateway->dir.'/ipn.php?i='.$this->row->id.'&u='.App::Auth()->uid.'&s='.App::Auth()->sesid,
	));
if ($r)
{
	?>
	<br />
	<div class="box">
		<form action="https://core.paystar.ir/api/pardakht/payment" method="post" id="frmPayStarPayment" name="frmPayStarPayment">
			<input type="hidden" name="token" value="<?php echo $p->data->token; ?>" />
			<span class="input-out"><input type="image" src="<?php echo SITEURL;?>/gateways/paystar/paystar_big.png" name="submit" class="tooltip" title="پرداخت از طريق درگاه پرداخت پی استار" alt="" onclick="document.frmPayStarPayment.submit();"/></span>
		</form>
	</div>
	<?php
}
else
{
	$message = $p->error;
	echo $message;
}

?>