<?php

namespace Drupal\commerce_paystar\PluginForm\OffsiteRedirect;

use Drupal\commerce_payment\PluginForm\PaymentOffsiteForm as BasePaymentOffsiteForm;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

class PaymentOffsiteForm extends BasePaymentOffsiteForm
{
	public function buildConfigurationForm(array $form, FormStateInterface $form_state)
	{
		$now = time();
		$payment = $this->entity;
		$order = $payment->getOrder();
		$order_id = $order->id();
		$redirect = Url::fromUri('base:/checkout/' . $order_id . '/payment/return/', array('absolute' => TRUE))->toString();
		$redirect = $form['#return_url'];
		$amount = $payment->getAmount()->getNumber();
		$payment_gateway_plugin = $payment->getPaymentGateway()->getPlugin();
		$gateway_configuration = $payment_gateway_plugin->getConfiguration();
		$terminal = $gateway_configuration['terminal'];
		require_once(drupal_get_path('module', 'commerce_paystar') . '/paystar/paystar_payment_helper.class.php');
		$p = new \PayStar_Payment_Helper($terminal);
		$r = $p->paymentRequest(array(
				'amount'   => intval($amount),
				'order_id' => $now, // $order_id.'#'.time(),
				'callback' => $redirect
			));
		if ($r) {
			$_SESSION['paystar'] = $now;
			return $this->buildRedirectForm($form, $form_state, 'https://core.paystar.ir/api/pardakht/payment', array('token' => $p->data->token), 'post');
		} else {
			exit($p->error);
		}
	}
}
