<?php defined('_JEXEC') or die('Restricted access');

/**
 * Joomseller Payment - PayStar Payment Plugin.
 * @package		Joomseller Payment
 * @subpackage	Payment Plugin
 */
class plgJSPaymentPaystar extends JPlugin {
	/** @var plugin parameter */
	var $params				= null;
	/** @var string Code name of payment method */
	var $_name				= 'paystar';
	/** @var array Payment method information */
	var $_info				= null;
	/** @var string live site */
	var $live_site			= null;
	/** @var array PayStar payment data */
	var $data				= array();
	/** @var string PayStar notify WEB */
	var $_web				= null;
	/** @var string PayStar notify URL */
	var $_url				= null;
	/** @var string PayStar Terminal */
	var $_terminal				= null;
	/** @var array PayStar notify */
	var $_ppnotify			= array(
								'valid_ip'			=> true,
								'order_stt'			=> '',
								'email_sbj'			=> '',
								'email_body'		=> ''
								);


	/**
	 * Constructor
	 */
	function __construct(& $subject, $params) {
		parent::__construct($subject, $params);
		
		// init variables
		$this->_name = 'paystar';
		$this->_web = 'https://paystar.ir';
		$this->_url = 'https://paystar.ir';
		$this->live_site = JUri::base();
		$this->_terminal = $this->params->get('paystar_terminal');
	}

	/**
	 * Get payment info method.
	 */
	function onPaymentInfo() {
		if (empty($this->_info)) {
			$this->_info = array(
				'code'   => 'paystar',
				'name'   => JText::_('PayStar'),
				'image'  => $this->params->get('payment_image'),
				'use_cc' => 0,
			);
		}
		return $this->_info;
	}

	/**
	 * Process payment method.
	 */
	function onProcessPayment($order)
	{
		if ($order->payment_method != $this->_name) return JOOMSELLER_PAYMENT_PROCESS_NO_CC;
		require_once(dirname(__FILE__) . '/paystar_payment_helper.class.php');
		$p = new PayStar_Payment_Helper($this->_terminal);
		$r = $p->paymentRequest(array(
				'amount'   => intval(ceil($order->total_price)),
				'order_id' => $order->id .'#'. $order->token .'#'. $order->total_price,
				'callback' => $order->notify_url . '&token=' . $order->token . '&id=' . $order->id,
			));
		if ($r)
		{
			$p->redirect();
		}
		else
		{
			echo $p->error;
		}
		return JOOMSELLER_PAYMENT_PROCESS_NO_CC;
	}

	/**
	 * Get order id from notification.
	 */
	function onPaymentNotify($payment_method) {		
		if ($payment_method != $this->_name) return array();
		$post	= JRequest::get('post');
		list($order_id, $token, $price) = explode('#', $post['order_id']);
		return array('order_id' => $order_id, 'transaction_id' => @$post['tracking_code']);
	}

	/**
	 * Verify payment notification.
	 */
	function onVerifyPayment($order) {
		if ($order->payment_method != $this->_name) return false;
		if($this->validate_ipn($order))
		{
			return array('status' => $this->_ppnotify['order_stt']);
		}
		return true;
	}
	
	/**
	 * Get paystar IPN validation.
	 * @return boolean
	 */
	function validate_ipn($order)
	{
		$post = JRequest::get('post');
		list($order_id, $token, $price) = explode('#', $post['order_id']);
		require_once(dirname(__FILE__) . '/paystar_payment_helper.class.php');
		$p = new PayStar_Payment_Helper($this->_terminal);
		$r = $p->paymentVerify(array_merge($_POST, array('amount' => intval(ceil($price)))));
		if ($r)
		{
			$this->_ppnotify['order_stt']	= "COMPLETED";
			$mailsubject = "PayStar IPN txn on your site";
			$mailbody = "Hello,\n\n";
			$mailbody .= "a PayStar transaction for you has been made on your website!\n";
			$mailbody .= "-----------------------------------------------------------\n";
			$mailbody .= "Transaction ID: ".$p->txn_id." \n";
			$mailbody .= "Order ID: ".$order_id."\n";
			$mailbody .= "Payment Status returned by PayStar: OK \n";
			$mailbody .= "Order Status Code: ".$this->_ppnotify['order_stt'];
			$this->_ppnotify['email_sbj'] = $mailsubject;
			$this->_ppnotify['email_body'] = $mailbody;
			return true;
		}
		else
		{
			$this->_ppnotify['order_stt']	= "FALSE";
			$mailsubject = "PayStar IPN Transaction on your site";
			$mailbody = "Hello,
				 a Failed PayStar Transaction on " . $this->_live_site . " requires your attention.
				 -----------------------------------------------------------
				 Order ID: " . $order_id . "
				 User ID: " . $order->user_id . "
				 Payment Status returned by PayStar: " . $p->error;
			$this->_ppnotify['email_sbj'] = $mailsubject;
			$this->_ppnotify['email_body'] = $mailbody;
		}
		return false;
	}
}