//Alpine
document.addEventListener('alpine:init', () => {

    Alpine.data("gateways", ()=>({
        pageLoaderIsActive: false,

        //table data
        tableData: [],
        tableLoaderIsActive: false,

        //modals
        modals: {
            status: {
                active: false,
                gateway: null
            },
            delete: {
                active: false,
                gateway: null
            },
        },

        init(){
            this.getPageData();
        },

        //request functions
        async getPageData(){
            this.tableLoaderIsActive = true;

            try{

                const result = await apiRequest('gateland/gateway/index', {
                    method: 'POST',
                })

                if(result.success){
                    const data = result.data;
                    this.tableData = data.gateways;
                    this.isProActive = data.is_pro_active;
                }else{
                    notyf.error(result.message ? result.message : 'حطایی رخ داده است!');
                    this.pageLoaderIsActive = false;
                }

                this.tableLoaderIsActive = false;

            }catch (error){
                console.error('Error fetching posts:', error);
                this.tableLoaderIsActive = false;
            }

        },

        async changeStatusGateway(){
            this.modals.status.active = false;
            this.tableLoaderIsActive = true;

            try{

                const result = await apiRequest('gateland/gateway/change-status', {
                    method: 'POST',
                    data:{
                        gateway_id: this.modals.status.gateway.id,
                        status: this.modals.status.gateway.status === 'inactive' ? 'active' : 'inactive'
                    }
                })

                if(result.success){
                    notyf.success(result.message ? result.message : 'درخواست با موفقیت انجام شد.');
                    this.getPageData();
                }else{
                    notyf.error(result.message ? result.message : 'حطایی رخ داده است!');
                }

            }catch (error){
                console.error('Error fetching posts:', error);
                this.tableLoaderIsActive = false;
            }

        },

        async deleteGateway(){
            this.modals.delete.active = false;
            this.tableLoaderIsActive = true;

            try{

                const result = await apiRequest('gateland/gateway/delete', {
                    method: 'POST',
                    data:{
                        gateway_id: this.modals.delete.gateway.id,
                    }
                })

                if(result.success){
                    notyf.success(result.message ? result.message : 'درخواست با موفقیت انجام شد.');
                    this.getPageData();
                }else{
                    notyf.error(result.message ? result.message : 'حطایی رخ داده است!');
                    this.tableLoaderIsActive = false;
                }

            }catch (error){
                console.error('Error fetching posts:', error);
                this.tableLoaderIsActive = false;
            }

        },

        openStatusModal(data){
            this.modals.status.active = true;
            this.modals.status.gateway = data;
        },

        openDeleteModal(data){
            this.modals.delete.active = true;
            this.modals.delete.gateway = data;
        }

    }))

})