//Alpine
document.addEventListener('alpine:init', () => {

    Alpine.data("transaction", ()=>({
        pageLoaderIsActive: false,

        //page data
        transaction: null,
        inquiryLoaderIsActive: false,

        async init(){
            const transaction = await this.getTransaction(getQueryParam('transaction_id'));

            if(transaction){
                this.transaction = transaction;
            }
        },

        //request functions
        async getTransaction(transactionId){
            this.pageLoaderIsActive = true;

            try{

                const result = await apiRequest('gateland/transaction/view', {
                    method: 'POST',
                    data: {
                        transaction_id: transactionId
                    }
                })

                if(result.success){
                    const data = result.data;
                    this.pageLoaderIsActive = false;
                    return data;
                }else{
                    notyf.error(result.message ? result.message : 'حطایی رخ داده است!');
                    this.pageLoaderIsActive = false;
                }


            }catch (error){
                console.error('Error fetching posts:', error);
                this.fromLoaderIsActive = false;
            }

            return false;

        },
        
        async inquiryTransaction(transactionId){
            this.inquiryLoaderIsActive = true;

            try{

                const result = await apiRequest('gateland/transaction/inquiry', {
                    method: 'POST',
                    data: {
                        transaction_id: transactionId
                    }
                })

                if(result.success){
                    notyf.success(result.message ? result.message : 'درخواست با موفقیت انجام شد');
                    this.inquiryLoaderIsActive = false;
                    await this.getTransaction(transactionId);
                }else{
                    notyf.error(result.message ? result.message : 'حطایی رخ داده است!');
                    this.inquiryLoaderIsActive = false;
                }

            }catch (error){
                console.error('Error fetching posts:', error);
                this.fromLoaderIsActive = false;
            }

        }

    }))

})




















