<?php


namespace Nabik\Gateland\Gateways;


use Nabik\Gateland\Enums\Transaction\CurrenciesEnum;
use Nabik\Gateland\Gateways\Features\ShaparakFeature;
use Nabik\Gateland\Models\Transaction;

class ParsianGateway extends BaseGateway implements ShaparakFeature {

	protected string $name = 'بانک پارسیان';

	protected string $description = 'تجارت الکترونیک پارسیان - pec';

	protected string $url = 'https://l.nabik.net/pec';

	public function request( Transaction $transaction ): void {
		throw new \Exception( sprintf( "جهت استفاده از درگاه «%s» به نسخه حرفه‌ای ارتقا دهید.", esc_attr( $this->name ) ) );
	}

	public function inquiry( Transaction $transaction ): bool {
		return false;
	}

	public function redirect( Transaction $transaction ) {
	}

	public function currencies(): array {
		return [
			CurrenciesEnum::IRT,
		];
	}

	public function options(): array {
		return [
			[
				'label' => 'کد کاربری (PIN Code)',
				'key'   => 'login_account',
			],
		];
	}

	public static function messages( $errorCode ) {
		$messages = [
			- 32768 => 'خطای ناشناخته رخ داده است.',
			- 1552  => 'برگشت تراکنش مجاز نمی باشد.',
			- 1551  => 'برگشت تراکنش قبلاً انجام شده است.',
			- 1550  => 'برگشت تراکنش در وضعیت جاری امکان پذیر نمی باشد.',
			- 1549  => 'زمان مجاز برای درخواست برگشت تراکنش به اتمام رسیده است.',
			- 1548  => 'فراخوانی سرویس درخواست پرداخت قبض ناموفق بود.',
			- 1540  => 'تاييد تراکنش ناموفق مي باشد.',
			- 1536  => 'فراخوانی سرویس درخواست شارژ تاپ آپ ناموفق بود.',
			- 1533  => 'تراکنش قبلاً تایید شده است.',
			1532    => 'تراکنش از سوی پذیرنده تایید شد.',
			- 1531  => 'تراکنش به دلیل انصراف شما در بانک ناموفق بود.',
			- 1530  => 'پذیرنده مجاز به تایید این تراکنش نمی باشد.',
			- 1528  => 'اطلاعات پرداخت یافت نشد.',
			- 1527  => 'انجام عملیات درخواست پرداخت تراکنش خرید ناموفق بود.',
			- 1507  => 'تراکنش برگشت به سوئیچ ارسال شد.',
			- 1505  => 'تایید تراکنش توسط پذیرنده انجام شد.',
			- 132   => 'مبلغ تراکنش کمتر از حداقل مجاز می باشد.',
			- 131   => 'Token نامعتبر می باشد.',
			- 130   => 'Token زمان منقضی شده است.',
			- 128   => 'قالب آدرس IP معتبر نمی باشد.',
			- 127   => 'آدرس اینترنتی معتبر نمی باشد.',
			- 126   => 'کد شناسایی پذیرنده معتبر نمی باشد.',
			- 121   => 'رشته داده شده بطور کامل عددی نمی باشد.',
			- 120   => 'طول داده ورودی معتبر نمی باشد.',
			- 119   => 'سازمان نامعتبر می باشد.',
			- 118   => 'مقدار ارسال شده عدد نمی باشد.',
			- 117   => 'طول رشته کم تر از حد مجاز می باشد.',
			- 116   => 'طول رشته بیش از حد مجاز می باشد.',
			- 115   => 'شناسه پرداخت نامعتبر می باشد.',
			- 114   => 'شناسه قبض نامعتبر می باشد.',
			- 113   => 'پارامتر ورودی خالی می باشد.',
			- 112   => 'شماره سفارش تکراری است.',
			- 111   => 'مبلغ تراکنش بیش از حد مجاز پذیرنده می باشد.',
			- 108   => 'قابلیت برگشت تراکنش برای پذیرنده غیر فعال می باشد.',
			- 107   => 'قابلیت ارسال تاییده تراکنش برای پذیرنده غیر فعال می باشد.',
			- 106   => 'قابلیت شارژ برای پذیرنده غیر فعال می باشد.',
			- 105   => 'قابلیت تاپ آپ برای پذیرنده غیر فعال می باشد.',
			- 104   => 'قابلیت پرداخت قبض برای پذیرنده غیر فعال می باشد.',
			- 103   => 'قابلیت خرید برای پذیرنده غیر فعال می باشد.',
			- 102   => 'تراکنش با موفقیت برگشت داده شد.',
			- 101   => 'پذیرنده اهراز هویت نشد.',
			- 100   => 'پذیرنده غیرفعال می باشد.',
			- 1     => 'خطای سرور.',
			0       => 'عملیات موفق می باشد.',
			1       => 'صادرکننده ی کارت از انجام تراکنش صرف نظر کرد.',
			2       => 'عملیات تاییدیه این تراکنش قبلا باموفقیت صورت پذیرفته است.',
			3       => 'پذیرنده ی فروشگاهی نامعتبر می باشد.',
			5       => 'از انجام تراکنش صرف نظر شد.',
			6       => 'بروز خطايي ناشناخته.',
			8       => 'باتشخیص هویت دارنده ی کارت، تراکنش موفق می باشد.',
			9       => 'درخواست رسيده در حال پي گيري و انجام است.',
			10      => 'تراکنش با مبلغي پايين تر از مبلغ درخواستي ( کمبود حساب مشتري ) پذيرفته شده است.',
			12      => 'تراکنش نامعتبر است.',
			13      => 'مبلغ تراکنش نادرست است.',
			14      => 'شماره کارت ارسالی نامعتبر است (وجود ندارد)',
			15      => 'صادرکننده ی کارت نامعتبراست (وجود ندارد)',
			17      => 'مشتري درخواست کننده حذف شده است.',
			20      => 'در موقعيتي که سوئيچ جهت پذيرش تراکنش نيازمند پرس و جو از کارت است ممکن است درخواست از کارت ( ترمينال) بنمايد اين پيام مبين نامعتبر بودن جواب است.',
			21      => 'در صورتي که پاسخ به در خواست ترمينا ل نيازمند هيچ پاسخ خاص يا عملکردي نباشيم اين پيام را خواهيم داشت.',
			22      => 'تراکنش مشکوک به بد عمل کردن ( کارت ، ترمينال ، دارنده کارت ) بوده است لذا پذيرفته نشده است.',
			30      => 'قالب پیام دارای اشکال است.',
			31      => 'پذیرنده توسط سوئی پشتیبانی نمی شود.',
			32      => 'تراکنش به صورت غير قطعي کامل شده است. به عنوان مثال تراکنش سپرده گزاري که از ديد مشتري کامل شده است ولي مي بايست تکميل گردد.',
			33      => 'تاریخ انقضای کارت سپری شده است.',
			38      => 'تعداد دفعات ورود رمزغلط بیش از حدمجاز است. کارت توسط دستگاه ضبط شود.',
			39      => 'کارت حساب اعتباری ندارد.',
			40      => 'عملیات درخواستی پشتیبانی نمی گردد.',
			41      => 'کارت مفقودی می باشد.',
			43      => 'کارت مسروقه می باشد.',
			45      => 'قبض قابل پرداخت نمی باشد.',
			51      => 'موجودی کافی نمی باشد.',
			54      => 'تاریخ انقضای کارت سپری شده است.',
			55      => 'رمز کارت نا معتبر است.',
			56      => 'کارت نا معتبر است.',
			57      => 'انجام تراکنش مربوطه توسط دارنده ی کارت مجاز نمی باشد.',
			58      => 'انجام تراکنش مربوطه توسط پایانه ی انجام دهنده مجاز نمی باشد.',
			59      => 'کارت مظنون به تقلب است.',
			61      => 'مبلغ تراکنش بیش از حد مجاز می باشد.',
			62      => 'کارت محدود شده است.',
			63      => 'تمهیدات امنیتی نقض گردیده است.',
			65      => 'تعداد درخواست تراکنش بیش از حد مجاز می باشد.',
			68      => 'پاسخ لازم براي تکميل يا انجام تراکنش خيلي دير رسيده است.',
			69      => 'تعداد دفعات تکرار رمز از حد مجاز گذشته است .',
			75      => 'تعداد دفعات ورود رمزغلط بیش از حدمجاز است.',
			78      => 'کارت فعال نیست.',
			79      => 'حساب متصل به کارت نا معتبر است یا دارای اشکال است.',
			80      => 'درخواست تراکنش رد شده است.',
			81      => 'کارت پذيرفته نشد.',
			83      => 'سرويس دهنده سوئيچ کارت تراکنش را نپذيرفته است.',
			84      => 'در تراکنشهايي که انجام آن مستلزم ارتباط با صادر کننده است در صورت فعال نبودن صادر کننده اين پيام در پاسخ ارسال خواهد شد.',
			91      => 'سيستم صدور مجوز انجام تراکنش موقتا غير فعال است و يا  زمان تعيين شده براي صدور مجوز به پايان رسيده است.',
			92      => 'مقصد تراکنش پيدا نشد.',
			93      => 'امکان تکميل تراکنش وجود ندارد.',
		];

		return $messages[ $errorCode ] ?? 'خطا غیرمنتظره! لطفا با مدیر وب سایت تماس بگیرید.';
	}
}