//Alpine
document.addEventListener('alpine:init', () => {

    Alpine.data("editGateway", ()=>({
        pageLoaderIsActive: false,

        //pagedata
        fromLoaderIsActive: false,
        gateway: null,

        async init(){
            const gateway = await this.getGateway(getQueryParam('gateway_id'));

            if(gateway){
                this.gateway = gateway;
            }

        },

        //request functions
        async getGateway(gatewayId){
            this.fromLoaderIsActive = true;

            try{

                const result = await apiRequest('gateland/gateway/overview', {
                    method: 'POST',
                    form: true,
                    data: {
                        gateway_id: gatewayId,
                        from_date: 1749326676,
                        to_date: 1749326676
                    }
                })

                if(result.success){
                    const data = result.data;
                    data.gateway.options = data.gateway.options.map(item=>{
                        item.model = data.gateway.data[item.key];
                        item.errorMsg = ''
                        return item;
                    });
                    this.fromLoaderIsActive = false;
                    return data.gateway;
                }else{
                    notyf.error(result.message ? result.message : 'حطایی رخ داده است!');
                    this.fromLoaderIsActive = false;
                }


            }catch (error){
                console.error('Error fetching posts:', error);
                this.fromLoaderIsActive = false;
            }

            return false;

        },

        async editGateway(data){
            this.pageLoaderIsActive = true;

            try {

                const result = await apiRequest('gateland/gateway/update', {
                    method: 'POST',
                    data
                })

                if(result.success){
                    notyf.success('درگاه با موفقیت بروزرسانی شد. در حال انتقال به لیست درگاه‌ها ...');
                    setTimeout(()=>{
                        window.location.replace(window.origin + window.location.pathname + '?page=gateland-gateways');
                        this.pageLoaderIsActive = false;
                    }, 1500)
                }else{
                    notyf.error(result.message ? result.message : 'حطایی رخ داده است!');
                    this.pageLoaderIsActive = false;
                }

            }catch (error){
                console.error('Error fetching posts:', error);
                this.pageLoaderIsActive = false;
            }

        },

        submit(){

            const data = {};
            this.gateway.options.forEach(item=>{
                data[item.key] = item.model;
            })

            console.log(data)

            this.editGateway({
                gateway_id: getQueryParam('gateway_id'),
                data
            });
        }

    }))

})




















