<?php

use Nabik\Gateland\Enums\Transaction\CurrenciesEnum;
use Nabik\Gateland\Enums\Transaction\StatusesEnum;
use Nabik\Gateland\Helper;
use Nabik\Gateland\Models\Transaction;

defined( 'ABSPATH' ) || exit;

wp_enqueue_style('custom-style', GATELAND_URL . 'dev_assets/css/style.css', [], GATELAND_VERSION);
wp_enqueue_style('notyf-style', GATELAND_URL . 'dev_assets/css/notyf.min.css', [], GATELAND_VERSION);

wp_enqueue_script('notyf-script', GATELAND_URL . 'dev_assets/js/notyf.min.js', [], GATELAND_VERSION, true);
wp_enqueue_script('global-script', GATELAND_URL . 'dev_assets/js/global.js', ['notyf-script'], GATELAND_VERSION, true);
wp_enqueue_script('page-script', GATELAND_URL . 'dev_assets/js/page/transaction.js', [], GATELAND_VERSION, true);
wp_enqueue_script('alpine-script', GATELAND_URL . 'dev_assets/js/alpine.min.js', ['global-script', 'page-script'], GATELAND_VERSION, ['strategy' => 'defer']);


wp_localize_script('global-script', 'gateland', [
    'root' => esc_url_raw(rest_url()),
    'nonce' => wp_create_nonce('wp_rest'),
]);

?>

<section x-data="transaction" class="text-base">

    <section class="bg-[#F9FAFB] text-gray-900 py-6 md:pl-5 pl-2.5">
        <div class="container">

            <div class="mb-6">
                <div class="mb-3">
                    <a href="?page=gateland-transactions" class="inline-flex items-center gap-2 hover:translate-x-0.5">
                        <img src="<?php echo GATELAND_URL . 'dev_assets'; ?>/image/icons/arrow-back.svg">
                        <div class="text-sm text-primary-500 font-semibold">
                            بازگشت به لیست تراکنش‌ها
                        </div>
                    </a>
                </div>
                <div class="flex flex-wrap gap-2">
                    <div class="font-semibold text-lg">
                        جزئیات تراکنش
                        <span x-show="transaction" x-text="'شماره ' + transaction?.id"></span>
                    </div>

                    <div class="flex flex-wrap items-center gap-x-2 gap-y-1 mr-auto">
                        <button
                                x-show="transaction"
                                x-cloak
                                @click="$store.page.printTransaction()"
                                class="flex items-center text-nowrap gap-2 text-sm text-primary-700 font-semibold rounded-md hover:bg-primary-100 py-2 px-3"
                        >
                            <img src="<?php echo GATELAND_URL . 'dev_assets'; ?>/image/icons/print.svg">
                            <span>
                                   پرینت تراکنش
                                </span>
                        </button>
                    </div>
                </div>
            </div>

            <div>
                <!-- skeleton -->
                <template x-if-="pageLoaderIsActive">
                    <div class="grid grid-cols-12 md:gap-4 gap-y-4 bg-white border border-gray-200 rounded-xl py-4 px-6 mb-5">
                        <template x-for="item in [1,2,3,4]">
                            <div class="lg:col-span-3 sm:col-span-6 col-span-full">
                                <div class="skeleton w-16 h-4 rounded-full mb-1.5"></div>
                                <div class="skeleton w-20 h-5 rounded-full"></div>
                            </div>
                        </template>
                    </div>
                </template>

                <template x-if="!pageLoaderIsActive">
                    <div class="grid grid-cols-12 md:gap-4 gap-y-4 bg-white border border-gray-200 rounded-xl py-4 px-6 mb-5">
                        <div class="lg:col-span-3 sm:col-span-6 col-span-full">
                            <div class="text-primary-500 text-xs mb-1.5">شماره تراکنش: </div>
                            <div class="text-primary-700 text-sm">
                        <span x-text="transaction?.id">
                            </div>
                        </div>
                        <div class="lg:col-span-3 sm:col-span-6 col-span-full">
                            <div class="text-primary-500 text-xs mb-1.5">مبلغ:</div>
                            <div class="text-primary-700 text-sm">
                       <span x-text="transaction?.amount">
                            </div>
                        </div>
                        <div class="lg:col-span-3 sm:col-span-6 col-span-full">
                            <div class="text-primary-500 text-xs mb-1.5">وضعیت:</div>
                            <div
                                    class="inline-block rounded-full text-xs"
                                    :style="transaction?.status_style"
                            >
                        <span x-text="transaction?.status">
                            </div>
                        </div>
                        <div class="lg:col-span-3 sm:col-span-6 col-span-full">
                            <div class="text-primary-500 text-xs mb-1.5">درگاه: </div>
                            <div class="text-primary-700 text-sm">
                       <span x-text="transaction?.gateway">
                            </div>
                        </div>
                    </div>
                </template>
            </div>

            <!-- levels-->
            <div>
                <!-- skeleton -->
                <template x-if="pageLoaderIsActive">
                    <div class="bg-white border border-gray-100 rounded-2xl py-8 md:px-8 px-3 mb-5">
                    <div class="flex justify-center">

                        <div class="w-[180px] text-center">
                            <div class="relative z-10 flex justify-center mb-3">
                                <!-- circle -->
                                <div class="size-8 rounded-full">
                                    <div class="skeleton size-8 bg-primary-100 flex items-center justify-center rounded-full">
                                    </div>
                                </div>

                                <!--line-->
                                <div class="w-1/2 absolute -z-10 top-[50%] -mt-[1px] left-0 h-[2px] bg-gray-200"></div>
                            </div>
                            <div class="text-center px-0.5">
                                <div class="skeleton sm:w-20 w-16 h-5 rounded-full mb-1 mx-auto"></div>
                                <div class="skeleton sm:w-28 w-20 h-4 rounded-full mb-2 mx-auto"></div>
                            </div>
                        </div>

                        <div class="w-[180px] text-center">
                            <div class="relative z-10 flex justify-center mb-3">
                                <!-- circle -->
                                <div class="size-8 rounded-full">
                                    <div class="skeleton size-8 bg-primary-100 flex items-center justify-center rounded-full">
                                    </div>
                                </div>

                                <!--line-->
                                <div class="w-1/2 absolute -z-10 top-[50%] -mt-[1px] right-0 h-[2px] bg-gray-200"></div>
                                <div class="w-1/2 absolute -z-10 top-[50%] -mt-[1px] left-0 h-[2px] bg-gray-200"></div>
                            </div>
                            <div class="text-center px-0.5">
                                <div class="skeleton sm:w-20 w-16 h-5 rounded-full mb-1 mx-auto"></div>
                                <div class="skeleton sm:w-28 w-20 h-4 rounded-full mb-2 mx-auto"></div>
                            </div>
                        </div>

                        <div class="w-[180px] text-center">
                            <div class="relative z-10 flex justify-center mb-3">
                                <!-- circle -->
                                <div class="size-8 rounded-full">
                                    <div class="skeleton size-8 bg-primary-100 flex items-center justify-center rounded-full">
                                    </div>
                                </div>

                                <!--line-->
                                <div class="w-1/2 absolute -z-10 top-[50%] -mt-[1px] right-0 h-[2px] bg-gray-200"></div>
                            </div>
                            <div class="text-center px-0.5">
                                <div class="skeleton sm:w-20 w-16 h-5 rounded-full mb-1 mx-auto"></div>
                                <div class="skeleton sm:w-28 w-20 h-4 rounded-full mb-2 mx-auto"></div>
                            </div>
                        </div>

                    </div>
                </div>
                </template>

                <template x-if="!pageLoaderIsActive && transaction">
                    <div class="bg-white border border-gray-100 rounded-2xl py-8 md:px-8 px-3 mb-5">
                        <div class="flex justify-center">

                            <div class="w-[200px] text-center">
                                <div class="relative z-10 flex justify-center mb-3">
                                    <!-- circle -->
                                    <div class="size-8 rounded-full">
                                        <div class="size-8 bg-primary-100 flex items-center justify-center rounded-full">
                                            <img src="<?php echo GATELAND_URL . 'dev_assets'; ?>/image/icons/tick.svg">
                                        </div>
                                    </div>

                                    <!--line-->
                                    <div class="w-1/2 absolute -z-10 top-[50%] -mt-[1px] left-0 h-[2px] bg-gray-200"></div>
                                </div>
                                <div class="text-center px-0.5">
                                    <div class="text-sm font-semibold text-primary-700 mb-1">
                                        انتخاب درگاه
                                    </div>
                                    <div class="text-xs font-normal text-primary-600 mb-2">
                                        <span x-text="transaction.created_at"></span>
                                    </div>
                                </div>
                            </div>

                            <div class="w-[200px] text-center">
                                <div class="relative z-10 flex justify-center mb-3">
                                    <!-- circle -->
                                    <div class="size-8 rounded-full">
                                        <template x-if="transaction.paid_at">
                                            <div class="size-8 bg-primary-100 flex items-center justify-center rounded-full">
                                                <img src="<?php echo GATELAND_URL . 'dev_assets'; ?>/image/icons/tick.svg">
                                            </div>
                                        </template>
                                        <template x-if="!transaction.paid_at">
                                            <div class="size-8 bg-warning-100 flex items-center justify-center rounded-full shadow-[0_1px_2px_0_#1018280F]">
                                                <img src="<?php echo GATELAND_URL . 'dev_assets'; ?>/image/icons/alert-triangle.svg">
                                            </div>
                                        </template>
                                    </div>

                                    <!--line-->
                                    <div class="w-1/2 absolute -z-10 top-[50%] -mt-[1px] right-0 h-[2px] bg-gray-200"></div>
                                    <div class="w-1/2 absolute -z-10 top-[50%] -mt-[1px] left-0 h-[2px] bg-gray-200"></div>
                                </div>
                                <div class="text-center px-0.5">
                                    <div class="text-sm font-semibold text-primary-700 mb-1">
                                        تاریخ پرداخت
                                    </div>
                                    <div class="text-xs font-normal text-primary-600 mb-2">
                                       <span x-text="transaction.paid_at || 'نامشخص'"></span>
                                    </div>
                                    <template x-if="!transaction.paid_at">
                                        <button
                                                @click="inquiryTransaction(transaction.id)"
                                                :disabled="inquiryLoaderIsActive"
                                                class="inline-flex items-center gap-2 bg-primary-50 hover:bg-primary-100 rounded-[8px] py-2 md:px-3.5 px-2"
                                        >
                                            <span  class="size-5 md:block hidden" :class="{'rotation-animation' : inquiryLoaderIsActive}">
                                                <img src="<?php echo GATELAND_URL . 'dev_assets'; ?>/image/icons/refresh.svg">
                                            </span>
                                            <span class="font-semibold text-primary-700 md:text-sm md:leading-5 text-[10px] leading-3">استعلام تایید تراکنش </span>
                                        </button>
                                    </template>
                                </div>
                            </div>

                            <template x-if="!transaction.paid_at">
                                <div class="w-[200px] text-center">
                                    <div class="relative z-10 flex justify-center mb-3">
                                        <!-- circle -->
                                        <div class="size-8 bg-gray-100 flex items-center justify-center rounded-full">
                                            <div class="size-2 bg-gray-200 rounded-full"></div>
                                        </div>

                                        <!--line-->
                                        <div class="w-1/2 absolute -z-10 top-[50%] -mt-[1px] right-0 h-[2px] bg-gray-200"></div>
                                    </div>
                                    <div class="text-center px-0.5">
                                        <div class="text-sm font-semibold text-primary-700 mb-1">
                                            تاریخ تایید
                                        </div>
                                    </div>
                                </div>
                            </template>

                            <template x-if="transaction.paid_at">
                                <div class="w-[200px] text-center">
                                    <div class="relative z-10 flex justify-center mb-3">
                                        <!-- circle -->
                                        <div class="size-8 rounded-full">
                                            <template x-if="transaction.verified_at">
                                                <div class="size-8 bg-primary-100 flex items-center justify-center rounded-full">
                                                    <img src="<?php echo GATELAND_URL . 'dev_assets'; ?>/image/icons/tick.svg">
                                                </div>
                                            </template>
                                            <template x-if="!transaction.verified_at">
                                                <div class="size-8 bg-warning-100 flex items-center justify-center rounded-full shadow-[0_1px_2px_0_#1018280F]">
                                                    <img src="<?php echo GATELAND_URL . 'dev_assets'; ?>/image/icons/alert-triangle.svg">
                                                </div>
                                            </template>
                                        </div>

                                        <!--line-->
                                        <div class="w-1/2 absolute -z-10 top-[50%] -mt-[1px] right-0 h-[2px] bg-gray-200"></div>
                                    </div>
                                    <div class="text-center px-0.5">
                                        <div class="text-sm font-semibold text-primary-700 mb-1">
                                            تاریخ تایید
                                        </div>
                                        <div class="text-xs font-normal text-primary-600 mb-2">
                                            <span x-text="transaction.verified_at || 'تایید نشده'"></span>
                                        </div>
                                        <template x-if="!transaction.verified_at">
                                            <button
                                                    @click="inquiryTransaction(transaction.id)"
                                                    :disabled="inquiryLoaderIsActive"
                                                    class="inline-flex items-center gap-2 bg-primary-50 hover:bg-primary-100 rounded-[8px] py-2 md:px-3.5 px-2"
                                            >
                                                <span  class="size-5 md:block hidden" :class="{'rotation-animation' : inquiryLoaderIsActive}">
                                                    <img src="<?php echo GATELAND_URL . 'dev_assets'; ?>/image/icons/refresh.svg">
                                                </span>
                                                <span class="font-semibold text-primary-700 md:text-sm md:leading-5 text-[10px] leading-3">استعلام تایید تراکنش </span>
                                            </button>
                                        </template>
                                    </div>
                                </div>
                            </template>

                        </div>
                    </div>
                </template>
            </div>

            <!--table-->
            <div class="bg-white border border-gray-300 rounded-xl overflow-hidden mb-5">

                <div class="flex items-center flex-wrap gap-3 p-4">
                    <div class="text-lg font-semibold order-first ml-auto">
                        اطلاعات تراکنش
                        <span x-show="transaction" x-text="transaction?.id"></span>
                    </div>
                </div>

                <div class="overflow-auto custom-scrollbar">
                    <table id="myTable" class="w-full">
                        <thead class="text-gray-600 text-nowrap text-xs font-semibold">
                            <tr class="border-y border-gray-200">
                            <td class="bg-gray-100 py-3 px-5">
                                عنوان
                            </td>
                            <td class="bg-gray-100 py-3 px-5">
                                اطلاعات
                            </td>
                        </tr>
                        </thead>
                        <tbody class="w-full text-sm text-gray-700">
                            <template x-if="pageLoaderIsActive">
                                <template x-for="item in [1,2,3,4]">
                                    <tr class="border-b bg-white border-gray-200">
                                        <td class="py-4 md:px-5 px-3">
                                            <span class="inline-block skeleton w-20 h-5 rounded-full"></span>
                                        </td>
                                        <td class="py-4 md:px-5 px-3">
                                            <span class="inline-block skeleton w-28 h-5 rounded-full"></span>
                                        </td>
                                    </tr>
                                </template>
                            </template>
                            <template x-if="!pageLoaderIsActive && transaction">
                                <template x-for="[key, value] in Object.entries(transaction.meta)">
                                    <tr class="border-b bg-white border-gray-200">
                                        <td class="py-4 md:px-5 px-3">
                                            <span x-text="key"></span>
                                        </td>
                                        <td class="py-4 md:px-5 px-3">
                                            <div x-text="value ? value : '-'" class="min-w-28"></div>
                                        </td>
                                    </tr>
                                </template>
                            </template>
                        </tbody>
                    </table>
                </div>

            </div>

            <div class="absolute w-screen h-screen top-0 left-0  -z-10">
                <div id="section-to-print" class="bg-white border border-gray-300 rounded-xl overflow-hidden mb-5">

                    <div class="flex items-center flex-wrap gap-3 p-4">
                        <div class="text-lg font-semibold order-first ml-auto">
                            اطلاعات تراکنش
                            <span x-show="transaction" x-text="transaction?.id"></span>
                        </div>
                    </div>

                    <div class="overflow-auto custom-scrollbar">
                        <table id="myTable" class="w-full">
                            <thead class="text-gray-600 text-nowrap text-xs font-semibold">
                            <tr class="border-y border-gray-200">
                                <td class="bg-gray-100 py-3 px-5">
                                    عنوان
                                </td>
                                <td class="bg-gray-100 py-3 px-5">
                                    اطلاعات
                                </td>
                            </tr>
                            </thead>
                            <tbody class="w-full text-sm text-gray-700">
                            <template x-if="pageLoaderIsActive">
                                <template x-for="item in [1,2,3,4]">
                                    <tr class="border-b bg-white border-gray-200">
                                        <td class="py-4 md:px-5 px-3">
                                            <span class="inline-block skeleton w-20 h-5 rounded-full"></span>
                                        </td>
                                        <td class="py-4 md:px-5 px-3">
                                            <span class="inline-block skeleton w-28 h-5 rounded-full"></span>
                                        </td>
                                    </tr>
                                </template>
                            </template>
                            <template x-if="!pageLoaderIsActive && transaction">
                                <template x-for="[key, value] in Object.entries(transaction.meta)">
                                    <tr class="border-b bg-white border-gray-200">
                                        <td class="py-4 md:px-5 px-3">
                                            <span x-text="key"></span>
                                        </td>
                                        <td class="py-4 md:px-5 px-3">
                                            <div x-text="value ? value : '-'" class="min-w-28"></div>
                                        </td>
                                    </tr>
                                </template>
                            </template>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>

        </div>
    </section>

</section>

<script>
    //Alpine
    document.addEventListener('alpine:init', () => {

        //for this page
        Alpine.store('page', {

            printTransaction(){
                console.log("salam")
                const style = document.createElement('style');
                style.setAttribute('id', 'print-style');
                style.innerHTML = `
                        @media print {
                            body {
                                visibility: hidden;
                            }
                            #section-to-print {
                                visibility: visible;
                            }
                        }
                    `;

                document.head.appendChild(style);
                window.print();
            }

        })

    })

</script>
