<?php

if (!class_exists('PayStar_Payment_Helper'))
{
	class PayStar_Payment_Helper
	{
		public function __construct($terminal = '')
		{
			$this->terminal = $terminal;
		}
		public function paymentRequest($data)
		{
			$result = $this->curl('https://core.paystar.ir/api/pardakht/create', $data);
			if (is_object($result) && isset($result->status)) {
				$this->data = $result->data;
				if ($result->status == 1) {
					return $result->data->ref_num;
				} else {
					$this->error = $result->message;
				}
			} else {
				$this->error = 'خطا در ارتباط با درگاه پی استار';
			}
			return false;
		}
		public function paymentVerify($data)
		{
			if ($data['status'] == 1) {
				$result = $this->curl('https://core.paystar.ir/api/pardakht/verify', array(
						'amount'  => $data['amount'],
						'ref_num' => $data['ref_num'],
					));
				if (is_object($result) && isset($result->status)) {
					$this->data = $result->data;
					if ($result->status == 1) {
						$this->txn_id = $data['tracking_code'];
						return true;
					} else {
						$this->error = $result->message;
					}
				} else {
					$this->error = 'خطا در ارتباط با درگاه پی استار';
				}
			} else {
				$this->error = 'تراکنش توسط کاربر لغو شد';
			}
			return false;
		}
		public function getPaymentForm($show_submit = true, $close_form = true)
		{
			echo '<form name="frmPayStarPayment" method="post" action="https://core.paystar.ir/api/pardakht/payment"><input type="hidden" name="token" value="'.$this->data->token.'" />';
			if ($show_submit) echo '<input type="submit" value="'.(is_string($show_submit)?$show_submit:'پرداخت').'" />';
			if ($close_form) echo '</form>';
		}
		public function redirect()
		{
			echo $this->getPaymentForm();
			echo '<script>document.frmPayStarPayment.submit();</script>';
		}
		public function curl($url, $data)
		{
			$ch = curl_init($url);
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
			curl_setopt($ch, CURLOPT_HTTPHEADER, $h = array('Authorization: Bearer '.$this->terminal, 'Content-Type: application/json'));
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$response = curl_exec($ch);
			curl_close($ch);
			return json_decode($response);
		}
	}
}
