<?php defined('_JEXEC') or die('Restricted access');

// IPN Url : http://www.SITE.com/index.php?option=com_hikashop&ctrl=checkout&task=notify&notif_payment=paystar&tmpl=component

class plgHikashoppaymentPaystar extends hikashopPaymentPlugin
{

	/* var $accepted_currencies = array(
		'AUD','BRL','CAD','EUR','GBP','JPY','USD','NZD','CHF','HKD','SGD','SEK',
		'DKK','PLN','NOK','HUF','CZK','MXN','MYR','PHP','TWD','THB','ILS','TRY',
		'IRR','R','IRT','T','TMN','RLS','TOM','RIAL','TOOMAN','TOMAN',
		'ریال','تومان','تومن'
	); */
	var $enabled = true;
	var $multiple = true;
	var $name = 'paystar';
	var $doc_form = 'paystar';

	function __construct(&$subject, $config)
	{
		parent::__construct($subject, $config);
	}

	function onBeforeOrderCreate(&$order,&$do)
	{
		if(parent::onBeforeOrderCreate($order, $do) === true)
			return true;
		if(empty($this->payment_params->paystar_terminal))
		{
			$this->app->enqueueMessage('Please check your &quot; PayStar &quot; plugin configuration');
			$do = false;
		}
	}

	function onAfterOrderConfirm(&$order, &$methods, $method_id)
	{
		parent::onAfterOrderConfirm($order, $methods, $method_id);
		$price = round($order->cart->full_total->prices[0]->price_value_with_tax,(int)$this->currency->currency_locale['int_frac_digits']);
		require_once(dirname(__FILE__) . '/paystar_payment_helper.class.php');
		$p = new PayStar_Payment_Helper($this->payment_params->paystar_terminal);
		$r = $p->paymentRequest(array(
				'amount'   => intval(ceil($price)),
				'order_id' => $order->order_id,
				'callback' => HIKASHOP_LIVE.'index.php?option=com_hikashop&ctrl=checkout&task=notify&notif_payment='.$this->name.'&tmpl=component&lang='.$this->locale . $this->url_itemid . '&orderID=' . $order->order_id,
			));
		if ($r)
		{
			$this->payment_params->token = $p->data->token;
			return $this->showPage('end');
		}
		else
		{
			return $p->error;
		}
	}

	function onPaymentNotification(&$statuses)
	{
		$filter = JFilterInput::getInstance();
		$dbOrder = $this->getOrder($_POST['order_id']);
		$this->loadPaymentParams($dbOrder);
		if(empty($this->payment_params))
		return false;
		$this->loadOrderData($dbOrder);
		if(empty($dbOrder))
		{
			echo 'Could not load any order for your notification ' . $_POST['order_id'];
			return false;
		}
		$order_id = $dbOrder->order_id;
		$price = round($dbOrder->order_full_price, (int)$this->currency->currency_locale['int_frac_digits']);
		$url = HIKASHOP_LIVE.'administrator/index.php?option=com_hikashop&ctrl=order&task=edit&order_id=' . $order_id;
		$order_text = "\r\n" . JText::sprintf('NOTIFICATION_OF_ORDER_ON_WEBSITE', $dbOrder->order_number, HIKASHOP_LIVE);
		$order_text .= "\r\n" . str_replace('<br/>', "\r\n", JText::sprintf('ACCESS_ORDER_WITH_LINK', $url));
		require_once(dirname(__FILE__) . '/paystar_payment_helper.class.php');
		$p = new PayStar_Payment_Helper($this->payment_params->paystar_terminal);
		$r = $p->paymentVerify(array_merge($_POST, array('amount' => intval(ceil($price)))));
		if ($r)
		{
			$history = new stdClass();
			$history->notified = 0;
			$history->amount = $price;
			$history->data = 'payment reference code : ' . $p->txn_id;
			$order_status = $this->payment_params->verified_status;
			$config =& hikashop_config();
			if($config->get('order_confirmed_status', 'confirmed') == $order_status)
			{
				$history->notified = 1;
			}
			$email = new stdClass();
			$email->subject = JText::sprintf('PAYMENT_NOTIFICATION_FOR_ORDER','PayStar',$order_status,$dbOrder->order_number);
			$email->body = str_replace('<br/>',"\r\n",JText::sprintf('PAYMENT_NOTIFICATION_STATUS','PayStar',$order_status)).' '.JText::sprintf('ORDER_STATUS_CHANGED',$order_status)."\r\n\r\n".$order_text;
			$this->modifyOrder($order_id, $order_status, $history, $email);
		}
		else
		{
			$order_status = $this->payment_params->invalid_status;
			$email = new stdClass();
			$email->subject = JText::sprintf('NOTIFICATION_REFUSED_FOR_THE_ORDER','PayStar').'invalid transaction';
			$email->body = JText::sprintf("Hello,\r\n A PayStar notification was refused because it could not be verified by the paystar server (or pay cenceled)")."\r\n\r\n".$p->error."\r\n\r\n".JText::sprintf('CHECK_DOCUMENTATION',HIKASHOP_HELPURL.'payment-paystar-error#invalidtnx');
			$action = false;
			$this->modifyOrder($order_id, $order_status, null, $email);
		}
		header('location: ' . HIKASHOP_LIVE.'index.php?option=com_hikashop&ctrl=order' );
		exit;
	}

	function onPaymentConfiguration(&$element)
	{
		$subtask = JRequest::getCmd('subtask', '');
		parent::onPaymentConfiguration($element);
	}

	function onPaymentConfigurationSave(&$element)
	{
		return true;
	}

	function getPaymentDefaultValues(&$element)
	{
		$element->payment_name = 'PayStar';
		$element->payment_description = 'You can pay by PayStar using this payment method';
		$element->payment_images = 'PayStar';
		$element->payment_params->invalid_status = 'cancelled';
		$element->payment_params->pending_status = 'created';
		$element->payment_params->verified_status = 'confirmed';
	}
}