<?php defined('_JEXEC') or die('Restricted access');

require_once (JPATH_ADMINISTRATOR.'/components/com_j2store/library/plugins/payment.php');
//require_once (JPATH_SITE.'/components/com_j2store/helpers/utilities.php');

class plgJ2StorePayment_paystar extends J2StorePaymentPlugin
{
    /**
     * @var $_element  string  Should always correspond with the plugin's filename,
     *                         forcing it to be unique
     */
    var $_element    = 'payment_paystar';

    /**
     * Constructor
     *
     * For php4 compatability we must not use the __constructor as a constructor for plugins
     * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
     * This causes problems with cross-referencing necessary for the observer design pattern.
     *
     * @param object $subject The object to observe
     * @param array  $config  An array that holds the plugin configuration
     * @since 1.5
     */
    function plgJ2StorePayment_paystar(& $subject, $config) {
        parent::__construct($subject, $config);
        $this->loadLanguage( '', JPATH_ADMINISTRATOR );
    }


    /**
     * @param $data     array       form post data
     * @return string   HTML to display
     */
    function _prePayment( $data )
    {
        $vars = new JObject();
        $vars->order_id = $data['order_id'];
        $vars->orderpayment_id = $data['orderpayment_id'];
        $vars->orderpayment_amount = $data['orderpayment_amount'];
        $vars->terminal = $this->params->get('terminal');
        $vars->first_name = $data['orderinfo']['billing_first_name'];
        $vars->last_name = $data['orderinfo']['billing_last_name'];
        $vars->email = $data['orderinfo']['user_email'];
        $vars->notify_url = JURI::root()."index.php?option=com_j2store&view=checkout&task=confirmPayment&orderpayment_type=".$this->_element."&paction=process&tmpl=component";
        return $this->_getLayout('prepayment', $vars);
    }

    /**
     * Processes the payment form
     * and returns HTML to be displayed to the user
     * generally with a success/failed message
     *
     * @param $data     array       form post data
     * @return string   HTML to display
     */
    function _postPayment( $data )
    {
        $paction = JRequest::getVar('paction');
        $vars = new JObject();
        switch ($paction)
        {
            case "display_message":
                $vars->message = JText::_('J2STORE_PAYSTAR_MESSAGE_PAYMENT_ACCEPTED_FOR_VALIDATION');
                $html = $this->_getLayout('message', $vars);
                $html .= $this->_displayArticle();
              break;
            case "process":
                if ($this->_process() == '')
                {
                    header('location: '. JURI::root()."index.php?option=com_j2store&view=checkout&task=confirmPayment&orderpayment_type=".$_REQUEST['orderpayment_type']."&paction=display_message");
                    exit;die;
                }
                else
                {
                    header('location: '. JURI::root()."index.php?option=com_j2store&view=checkout&task=confirmPayment&orderpayment_type=".$_REQUEST['orderpayment_type']."&paction=cancel");
                    exit;die;
                }
              break;
            case "cancel":
                $vars->message = JText::_( 'J2STORE_PAYSTAR_MESSAGE_CANCEL' );
                $html = $this->_getLayout('message', $vars);
              break;
            default:
                $vars->message = JText::_( 'J2STORE_PAYSTAR_MESSAGE_INVALID_ACTION' );
                $html = $this->_getLayout('message', $vars);
              break;
        }
        return $html;
    }

    /**
     * Prepares variables for the payment form
     *
     * @return unknown_type
     */
    function _renderForm( $data )
    {
        $user = JFactory::getUser();
        $vars = new JObject();
        $html = $this->_getLayout('form', $vars);
        return $html;
    }


    /**
     * Validates the IPN data
     *
     * @return string Empty string if data is valid and an error message otherwise
     * @access protected
     */
    function _validateIPN($amount)
    {
        require_once(dirname(__FILE__) . '/paystar_payment_helper.class.php');
        $p = new PayStar_Payment_Helper($this->params->get('terminal'));
        $r = $p->paymentVerify(array_merge($_POST, array('amount' => $amount)));
        if ($r)
        {
            $this->txn_id = $p->txn_id;
            return '';
        }
        else
        {
            return $p->error . ' . ' . JText::_('J2STORE_PAYSTAR_ERROR_IPN_VALIDATION');
        }
    }

    /**
     *
     * @return HTML
     */
    function _process()
    {
        $data = JRequest::get('post');
        //JTable::addIncludePath( JPATH_ADMINISTRATOR.'/components/com_j2store/tables' );
        //$orderpayment = JTable::getInstance('Orders', 'Table');
        F0FTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_j2store/tables');
        $orderpayment = F0FTable::getInstance('Order', 'J2StoreTable')->getClone();
        list($order_id, $orderpayment_id) = explode('#', $_POST['order_id']);
        $orderpayment->load(array('order_id'=>$order_id));
        $error = $this->_validateIPN(intval(ceil($orderpayment->get('orderpayment_amount'))));
        if ($error == '')
        {
            $data['payment_status'] = 'Completed';
            $data['txn_id'] = $this->txn_id;
        }
        else
        {
            $data['ipn_validation_results'] = $error;
            $data['payment_status'] = 'Failed';
        }
        $order_id           = (int) $order_id;
        $orderpayment_id    = (int) $orderpayment_id;
        $data['transaction_details'] = $this->_getFormattedTransactionDetails( $data );
        $payment_error = '';
        $payment_error = $this->_processSale( $data, $error );
        if ($payment_error)
        {
             $error .= $error ? "\n" . $payment_error : $payment_error;
        }
        if ($error)
        {
            $this->_sendErrorEmails($error, $data['transaction_details']);
            return $error;
        }
        return $error;
    }

    /**
     * Processes the sale payment
     *
     * @param array $data IPN data
     * @return boolean Did the IPN Validate?
     * @access protected
     */
    function _processSale( $data, $ipnValidationFailed='' )
    {
        $errors = array();
        if (!empty($ipnValidationFailed))
        {
            $errors[] = $ipnValidationFailed;
        }
        list($order_id, $orderpayment_id) = explode('#', $_POST['order_id']);
        //JTable::addIncludePath( JPATH_ADMINISTRATOR.'/components/com_j2store/tables' );
        //$orderpayment = JTable::getInstance('Orders', 'Table');
        F0FTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_j2store/tables');
        $orderpayment = F0FTable::getInstance('Order', 'J2StoreTable')->getClone();
        $orderpayment->load(array('order_id'=>$order_id));
        $orderpayment->transaction_details  = $data['transaction_details'];
        $orderpayment->transaction_id       = $data['txn_id'];
        $orderpayment->transaction_status   = $data['payment_status'];
        $orderpayment->order_state = JText::_('J2STORE_PENDING');
        $orderpayment->order_state_id = 4;
        if (count($errors))
        {
            $orderpayment->order_state = JText::_('J2STORE_FAILED');
            $orderpayment->order_state_id = 3;
        }
        elseif (@$data['payment_status'] == 'Pending')
        {
            $orderpayment->order_state = JText::_('J2STORE_PENDING');
            $orderpayment->order_state_id = 4;
        }
        else
        {
        	$orderpayment->payment_complete();
            $orderpayment->order_state = trim(JText::_('J2STORE_CONFIRMED'));
            $orderpayment->order_state_id = 1;
            $orderpayment->paypal_status = @$data['payment_status'];
            //JLoader::register( 'J2StoreHelperCart', JPATH_SITE.'/components/com_j2store/helpers/cart.php');
            //J2StoreHelperCart::removeOrderItems( $orderpayment->id );
        }
        if(!$orderpayment->store())
        {
            $errors[] = $orderpayment->getError();
        }
        //require_once (JPATH_SITE.'/components/com_j2store/helpers/orders.php');
        //J2StoreOrdersHelper::sendUserEmail($orderpayment->user_id, $orderpayment->order_id, $data['payment_status'], $orderpayment->order_state, $orderpayment->order_state_id);
        return count($errors) ? implode("\n", $errors) : '';
    }

    /**
     * Formatts the payment data for storing
     *
     * @param array $data
     * @return string
     */
    function _getFormattedTransactionDetails( $data )
    {
        $separator = "\n";
        $formatted = array();
        foreach ($data as $key => $value)
        {
            if ($key != 'view' && $key != 'layout')
            {
                $formatted[] = $key . ' = ' . $value;
            }
        }
        return count($formatted) ? implode("\n", $formatted) : '';
    }

    /**
     * Sends error messages to site administrators
     *
     * @param string $message
     * @param string $paymentData
     * @return boolean
     * @access protected
     */
    function _sendErrorEmails($message, $paymentData)
    {
        $mainframe = JFactory::getApplication();
        $config     = JComponentHelper::getParams('com_j2store');
        $mailfrom   = $config->get( 'emails_defaultemail', $mainframe->getCfg('mailfrom') );
        $fromname   = $config->get( 'emails_defaultname', $mainframe->getCfg('fromname') );
        $sitename   = $config->get( 'sitename', $mainframe->getCfg('sitename') );
        $siteurl    = $config->get( 'siteurl', JURI::root() );
        $recipients = $this->_getAdmins();
        $mailer = JFactory::getMailer();
        $subject = JText::sprintf('J2STORE_PAYSTAR_EMAIL_PAYMENT_NOT_VALIDATED_SUBJECT', $sitename);
        foreach ($recipients as $recipient)
        {
            $mailer = JFactory::getMailer();
            $mailer->addRecipient( $recipient->email );
            $mailer->setSubject( $subject );
            $mailer->setBody( JText::sprintf('J2STORE_PAYSTAR_EMAIL_PAYMENT_FAILED_BODY', $recipient->name, $sitename, $siteurl, $message, $paymentData) );
            $mailer->setSender(array( $mailfrom, $fromname ));
            $sent = $mailer->send();
        }
        return true;
    }

    /**
     * Gets admins data
     *
     * @return array|boolean
     * @access protected
     */
    function _getAdmins()
    {
        $db = JFactory::getDBO();
        $query = $db->getQuery(true);
        $query->select('u.name,u.email');
        $query->from('#__users AS u');
        $query->join('LEFT', '#__user_usergroup_map AS ug ON u.id=ug.user_id');
        $query->where('u.sendEmail = 1');
        $query->where('ug.group_id = 8');
        $db->setQuery($query);
        $admins = $db->loadObjectList();
        if ($error = $db->getErrorMsg()) {
            JError::raiseError(500, $error);
            return false;
        }
        return $admins;
    }
}
