<?php defined('_JEXEC') or die('Restricted access');

// IPN Url : http://www.SITE.com/index.php?option=com_jshopping&controller=checkout&task=step7&act=return&js_paymentclass=pm_paystar

class pm_paystar extends PaymentRoot
{

	function showPaymentForm($params, $pmconfigs)
	{
		include(dirname(__FILE__)."/paymentform.php");
	}

	function showAdminFormParams($params)
	{
		$array_params = array('paystar_terminal', 'transaction_end_status', 'transaction_pending_status', 'transaction_failed_status');
		foreach ($array_params as $key)
		{
			if (!isset($params[$key])) $params[$key] = '';
		}
      if (!isset($params['use_ssl'])) $params['use_ssl'] = 0;
      if (!isset($params['address_override'])) $params['address_override'] = 0;
		$orders = JSFactory::getModel('orders', 'JshoppingModel');
		include(dirname(__FILE__)."/adminparamsform.php");
	}

	function checkTransaction($pmconfigs, $order, $act)
	{
		$jshopConfig = JSFactory::getConfig();
		$pm_method = $this->getPmMethod();
		$order_id = $_POST['order_id'];
		require_once(dirname(__FILE__) . '/paystar_payment_helper.class.php');
		$p = new PayStar_Payment_Helper($pmconfigs['paystar_terminal']);
		$r = $p->paymentVerify(array_merge($_POST, array('amount' => intval(ceil($order->order_total)))));
		if ($r)
		{
			saveToLog("payment.log", "Order ID ".$order_id.". pay verified ".$p->txn_id);
			return array(1, "پرداخت با موفقیت انجام شد. شماره سفارش: $order_id , شماره پیگیری: ".$p->txn_id, $p->txn_id, $_REQUEST);
		}
		else
		{
			saveToLog("payment.log", "Order ID ".$order_id.". pay failed ".$p->error);
			return array(0, 'پرداخت لغو شد. ' . $p->error, 0, $_REQUEST);
		}
	}

	function showEndForm($pmconfigs, $order)
	{
		$jshopConfig = JSFactory::getConfig();
		$pm_method = $this->getPmMethod();
		$uri = JURI::getInstance();
		$liveurlhost = $uri->toString(array("scheme",'host', 'port'));
		$return = $liveurlhost.SEFLink("index.php?option=com_jshopping&controller=checkout&task=step7&act=return&js_paymentclass=".$pm_method->payment_class);
		$return .= "&orderID=".$order->order_id;
		require_once(dirname(__FILE__) . '/paystar_payment_helper.class.php');
		$p = new PayStar_Payment_Helper($pmconfigs['paystar_terminal']);
		$r = $p->paymentRequest(array(
				'amount'   => intval(ceil($order->order_total)),
				'order_id' => $order->order_id,
				'name'     => @$order->d_f_name.' '.@$order->d_l_name,
				'mail'     => @$order->email,
				'phone'    => @$order->d_phone,
				'callback' => $return,
			));
		if ($r)
		{
			$p->redirect();
		}
		else
		{
			echo $p->error;
		}
		exit;
	}

	function getUrlParams($pmconfigs)
	{
		$params = array();
		$params['order_id'] = $_POST['order_id'];
		$params['hash'] = "";
		$params['checkHash'] = 0;
		$params['checkReturnParams'] = 1;
		return $params;
	}

}

?>