<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * @category     :  ModuleBank
 * @package      :  ModuleBank_PayStarPayment
 *
 * @company      :  ModuleBank
 * @created by   :  Seyed Hamzeh Fazeli
 * @contact      :  www.ModuleBank.ir, support@modulebank.ir, 09160666110
 * @created on   :  August 2020
 * @copyright    :  Copyright (C) 2020. All rights reserved.
 * @author       :  Seyed Hamzeh Fazeli
 * @description  :  PayStar Gateway Payment for the component (Magento)
 */
class ModuleBank_Paystar_Block_Form extends Mage_Payment_Block_Form
{
    protected function _construct()
    {
        parent::_construct();
        $this->setTemplate('paystar/form.phtml');
    }

    public function getPaymentImageSrc()
    {
    	$locale = strtolower(Mage::app()->getLocale()->getLocaleCode());
    	$imgSrc = $this->getSkinUrl('images/paystar/'.$locale.'_outl.gif');

    	if (!file_exists(Mage::getDesign()->getSkinBaseDir().'/images/paystar/'.$locale.'_outl.gif')) {
    		$imgSrc = $this->getSkinUrl('images/paystar/intl_outl.gif');
    	}
    	return $imgSrc;
    }
}