<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * @category     :  ModuleBank
 * @package      :  ModuleBank_PayStarPayment
 *
 * @company      :  ModuleBank
 * @created by   :  Seyed Hamzeh Fazeli
 * @contact      :  www.ModuleBank.ir, support@modulebank.ir, 09160666110
 * @created on   :  August 2020
 * @copyright    :  Copyright (C) 2020. All rights reserved.
 * @author       :  Seyed Hamzeh Fazeli
 * @description  :  PayStar Gateway Payment for the component (Magento)
 */
class ModuleBank_Paystar_Block_Info extends Mage_Payment_Block_Info
{
    protected function _construct()
    {
        parent::_construct();
        $this->setTemplate('paystar/info.phtml');
    }

    public function getMethodCode()
    {
        return $this->getInfo()->getMethodInstance()->getCode();
    }

    protected function _toHtml()
    {
        $msg = $this->getMethod()->getTitle() . '<br/>';
        if ($this->getInfo()->getLastTransId() != '') {
            $msg .= $this->__('Transaction Trace Number : %s', $this->htmlEscape($this->getInfo()->getLastTransId())) . '<br/>';
        }
        return $msg;
    }

    public function toPdf()
    {
        $this->setTemplate('paystar/pdf/info.phtml');
        return $this->toHtml();
    }
}