<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * @category     :  ModuleBank
 * @package      :  ModuleBank_PayStarPayment
 *
 * @company      :  ModuleBank
 * @created by   :  Seyed Hamzeh Fazeli
 * @contact      :  www.ModuleBank.ir, support@modulebank.ir, 09160666110
 * @created on   :  August 2020
 * @copyright    :  Copyright (C) 2020. All rights reserved.
 * @author       :  Seyed Hamzeh Fazeli
 * @description  :  PayStar Gateway Payment for the component (Magento)
 */
class ModuleBank_Paystar_ProcessingController extends Mage_Core_Controller_Front_Action
{
    protected $_successBlockType  = 'paystar/success';
    protected $_failureBlockType  = 'paystar/failure';

    protected $_order = NULL;
    protected $_paymentInst = NULL;


    /**
     * Get singleton of Checkout Session Model
     *
     * @return Mage_Checkout_Model_Session
     */
    protected function _getCheckout()
    {
        return Mage::getSingleton('checkout/session');
    }

    public function redirectAction()
    {
        try {
            $session = $this->_getCheckout();

            $order = Mage::getModel('sales/order');
            $order->loadByIncrementId($session->getLastRealOrderId());
            if (!$order->getId()) {
                Mage::throwException('No order for processing found');
            }
            if ($order->getState() != Mage_Sales_Model_Order::STATE_PENDING_PAYMENT) {
                $order->setState(
                    Mage_Sales_Model_Order::STATE_PENDING_PAYMENT,
                    $this->_getPendingPaymentStatus(),
                    Mage::helper('paystar')->__('Customer was redirected to paystar gateway.')
                )->save();
            }

            if ($session->getQuoteId() && $session->getLastSuccessQuoteId()) {
                $session->setClickandbuyQuoteId($session->getQuoteId());
                $session->setClickandbuySuccessQuoteId($session->getLastSuccessQuoteId());
                $session->setClickandbuyRealOrderId($session->getLastRealOrderId());
                $session->getQuote()->setIsActive(false)->save();
                //$session->clear();
            }

            $this->loadLayout();
            $this->renderLayout();
            return;
        } catch (Mage_Core_Exception $e) {
            $this->_getCheckout()->addError($e->getMessage());
        } catch(Exception $e) {
            Mage::logException($e);
        }
		
		
        //$this->_redirect('checkout/cart');
    }
	public function responseAction()
	{
		if (!isset($_SESSION['paystar_token']))
		{
			session_destroy();
			session_id($_GET['shf_key']);
			session_start();
		}
		$session = $this->_getCheckout();
		//$orderid = $session->getPaystarPaymentRealOrderId();
		//$orderid = $session->getClickandbuyRealOrderId();
		//$orderid = $session->getLastRealOrderId();
		$orderid = $_POST['order_id'];
		$this->_order = Mage::getModel('sales/order')->loadByIncrementId($orderid);
		$this->_paymentInst = $this->_order->getPayment()->getMethodInstance();
		$price = intval(ceil($this->_order->getGrandTotal() * (in_array(strtoupper($this->_order->getOrderCurrency()->getCurrencyCode()), array('IRT','Toman','','')) ? 10 : 1)));
		require_once(dirname(dirname(__FILE__)) . '/paystar_payment_helper.class.php');
		$p = new PayStar_Payment_Helper($this->_paymentInst->getConfigData('terminal'));
		$r = $p->paymentVerify(array_merge($_POST, array('amount' => $price)));
		if ($r)
		{
			$message = "Payment Completed. OrderId : {$orderid} . PaymentRefrenceId : " . $p->txn_id;
			$this->_order->getPayment()->setTransactionId($p->txn_id);
			$this->_order->getPayment()->setLastTransId($p->txn_id);
			// create invoice
			if ($this->_order->canInvoice())
			{
				$invoice = $this->_order->prepareInvoice();
				$invoice->register()->capture();
				Mage::getModel('core/resource_transaction')
					->addObject($invoice)
					->addObject($invoice->getOrder())
					->save();
			}
			// add order history comment
			$message = sprintf($this->__("Yours order track number is %s"),$p->txn_id);
			$this->_order->addStatusToHistory($this->_paymentInst->getConfigData('order_status'), Mage::helper('paystar')->__('Payment complete'));
			$this->_order->addStatusToHistory($this->_paymentInst->getConfigData('order_status'), $message, true );
			// send email
			$this->_order->sendNewOrderEmail();
			$this->_order->setEmailSent(true);	
			$this->_order->save();
			Mage::getSingleton('core/session')->addSuccess($message);
			// redirect to success page
			$this->getResponse()->setBody(
				$this->getLayout()
					->createBlock($this->_successBlockType)
					->setOrder($this->_order)
					->toHtml());
		}
		else
		{
			$message = $p->error;
			Mage::getSingleton('core/session')->addError($message);
			$this->_redirect('paystar/processing/caberror');
			//die ('PayStar Payment Error: '.$message);
		}
	}

    public function successAction()
    {
        try {
            $session = $this->_getCheckout();
            $session->unsClickandbuyRealOrderId();
            $session->setQuoteId($session->getClickandbuyQuoteId(true));
            $session->setLastSuccessQuoteId($session->getClickandbuySuccessQuoteId(true));
            $this->_redirect('checkout/onepage/success');
            return;
        } catch (Mage_Core_Exception $e) {
            $this->_getCheckout()->addError($e->getMessage());
        } catch(Exception $e) {
            Mage::logException($e);
        }
        $this->_redirect('checkout/cart');
    }

    /**
     * ClickandBuy sub error action
     */
    public function caberrorAction()
    {
        // set quote to active
        $session = $this->_getCheckout();
        if ($quoteId = $session->getClickandbuyQuoteId()) {
            $quote = Mage::getModel('sales/quote')->load($quoteId);
            if ($quote->getId()) {
                $quote->setIsActive(true)->save();
                $session->setQuoteId($quoteId);
            }
        }

        $this->getResponse()->setBody(
            $this->getLayout()
                ->createBlock($this->_failureBlockType)
                ->setOrder($this->_order)
                ->toHtml()
        );
    }

	/**
	 * ClickandBuy sub success action
	 */
	public function cabsuccessAction()
	{
		$this->caberrorAction();
	}

    /**
     * Checking GET and SERVER variables.
     * Creating invoice if payment was successfull or cancel order if payment was declined
     */
    protected function _checkReturnedParams()
    {
        // get request variables
        $externalBDRID = $this->getRequest()->getParam('externalBDRID');
        $request = $this->getRequest()->getServer();

        /*
		  if (!isset($request['HTTP_X_USERID']) || !isset($request['HTTP_X_PRICE']) || !isset($request['HTTP_X_CURRENCY']) || !isset($request['HTTP_X_TRANSACTION']) || !isset($request['HTTP_X_CONTENTID']) || !isset($request['HTTP_X_USERIP']))
            throw new Exception('Request doesn\'t contain all required C&B elements.', 10);

        // validate request ip coming from ClickandBuy proxy
        $helper = Mage::helper('core/http');
        if (method_exists($helper, 'getRemoteAddr')) {
            $remoteAddr = $helper->getRemoteAddr();
        } else {
            $request = $this->getRequest()->getServer();
            $remoteAddr = $request['REMOTE_ADDR'];
        }
        if (substr($remoteAddr,0,11) != '217.22.128.') {
            throw new Exception('IP can\'t be validated as ClickandBuy-IP.', 20);
        }

        // validate ClickandBuy user id
        if (empty($request['HTTP_X_USERID']) || is_nan($request['HTTP_X_USERID']))
            throw new Exception('Invalid ClickandBuy-UID.', 30);
			*/

        // check order id
		list($orderId) = explode('-', $externalBDRID, 2);
        if (empty($orderId) || strlen($orderId) > 50)
            throw new Exception('Missing or invalid order ID', 30);

        // load order for further validation
        $this->_order = Mage::getModel('sales/order')->loadByIncrementId($orderId);
		if (!$this->_order->getId())
			throw new Exception('Order ID not found.', 35);

        // check transaction amount and currency
		if ($this->_order->getPayment()->getMethodInstance()->getConfigData('use_store_currency')) {
        	$price      = number_format($this->_order->getGrandTotal()*100,0,'.','');
        	$currency   = $this->_order->getOrderCurrencyCode();
    	} else {
        	$price      = number_format($this->_order->getBaseGrandTotal()*100,0,'.','');
        	$currency   = $this->_order->getBaseCurrencyCode();
    	}

		/*
		if (intval($price) != intval($request['HTTP_X_PRICE']/1000))
			throw new Exception('Transaction amount doesn\'t match.', 40);
		if ($currency != $request['HTTP_X_CURRENCY'])
			throw new Exception('Transaction currency doesn\'t match.', 50);
		*/

        return $externalBDRID;
    }

    protected function _getPendingPaymentStatus()
    {
        return Mage::helper('paystar')->getPendingPaymentStatus();
    }
}
