<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * @category     :  ModuleBank
 * @package      :  ModuleBank_PayStarPayment
 *
 * @company      :  ModuleBank
 * @created by   :  Seyed Hamzeh Fazeli
 * @contact      :  www.ModuleBank.ir, support@modulebank.ir, 09160666110
 * @created on   :  August 2020
 * @copyright    :  Copyright (C) 2020. All rights reserved.
 * @author       :  Seyed Hamzeh Fazeli
 * @description  :  PayStar Gateway Payment for the component (Magento)
 */
class ModuleBank_Paystar_Block_Redirect extends Mage_Core_Block_Template
{
    /**
     * Return checkout session instance
     *
     * @return Mage_Checkout_Model_Session
     */
    protected function _getCheckout()
    {
        return Mage::getSingleton('checkout/session');
    }

    /**
     * Return order instance
     *
     * @return Mage_Sales_Model_Order|null
     */
    protected function _getOrder()
    {
        if ($this->getOrder()) {
            return $this->getOrder();
        } elseif ($orderIncrementId = $this->_getCheckout()->getLastRealOrderId()) {
            return Mage::getModel('sales/order')->loadByIncrementId($orderIncrementId);
        } else {
            return null;
        }
    }

	public function getFormData()
	{
		$order = $this->_getOrder();
		$price = intval(ceil($order->getGrandTotal() * (in_array(strtoupper($order->getOrderCurrency()->getCurrencyCode()), array('IRT','Toman','تومن','تومان')) ? 10 : 1)));
		require_once(dirname(dirname(__FILE__)) . '/paystar_payment_helper.class.php');
		$p = new PayStar_Payment_Helper($order->getPayment()->getMethodInstance()->getConfigData('terminal'));
		$r = $p->paymentRequest(array(
				'amount'   => $price,
				'order_id' => $order->getIncrementId(),
				'callback' => Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_LINK) . 'paystar/processing/response/?shf_key='.session_id()
			));
		if ($r)
		{
			$_SESSION['paystar_token'] = $p->data->token;
			return array(1, $p->data->token);
		}
		else
		{
			return array(0, $p->error);
		}
    }
}
