<?php
class ControllerPaymentPaystar extends Controller 
{
	private $error = array();
	
	public function index() 
	{	
		/* Language */
		$this->load->language('payment/paystar');
		$this->document->setTitle($this->language->get('heading_title'));
		
		/* Model */
		$this->load->model('setting/setting');
		$this->load->model('localisation/order_status');
		
		/* (Update) */
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) 
		{
			$this->model_setting_setting->editSetting('paystar', $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');			
			$this->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
		}
		
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');
		$this->data['text_none'] = $this->language->get('text_none');
		$this->data['text_wait'] = $this->language->get('text_wait');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_settle'] = $this->language->get('button_settle');
		$this->data['button_refund'] = $this->language->get('button_refund');
		
		$this->data['tab_general'] = $this->language->get('tab_general');
		
		$this->data['fields_configuration_1'] = $this->language->get('fields_configuration_1');
		$this->data['fields_configuration_2'] = $this->language->get('fields_configuration_2');
		
		$this->data['entry_api_paystar'] = $this->language->get('entry_api_paystar');
		$this->data['entry_bank_paystar'] = $this->language->get('entry_bank_paystar');
		$this->data['entry_bconfig_paystar'] = $this->language->get('entry_bconfig_paystar');
		$this->data['entry_order_status'] = $this->language->get('entry_order_status');		
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		
		$this->data['paystar_copyright_a'] = $this->language->get('paystar_copyright_a');
		$this->data['paystar_copyright_b'] = $this->language->get('paystar_copyright_b');
		
		/* Warnings */
		$this->data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';

		/* Breadcrumbs */
		$this->data['breadcrumbs'] = array();
   		$this->data['breadcrumbs'][] = array('text' => $this->language->get('text_home'), 'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'), 'separator' => false);
   		$this->data['breadcrumbs'][] = array('text' => $this->language->get('text_payment'), 'href' => $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'), 'separator' => ' :: ');
   		$this->data['breadcrumbs'][] = array('text' => $this->language->get('heading_title'), 'href' => $this->url->link('payment/paystar', 'token=' . $this->session->data['token'], 'SSL'), 'separator' => ' :: ');
		
		/* Actions */
		$this->data['action'] = $this->url->link('payment/paystar', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['cancel'] = $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');	
		
		/* (Fields)->Payment */
		$this->data['api_paystar'] = isset($this->request->post['api_paystar']) ? $this->request->post['api_paystar'] : $this->config->get('api_paystar');
		$this->data['paystar_bank'] = isset($this->request->post['paystar_bank']) ? $this->request->post['paystar_bank'] : $this->config->get('paystar_bank');

		/* (Fields)->Application */
		$this->data['paystar_order_status_id'] = isset($this->request->post['paystar_order_status_id']) ? $this->request->post['paystar_order_status_id'] : $this->config->get('paystar_order_status_id');
		$this->data['paystar_sort_order'] = isset($this->request->post['paystar_sort_order']) ? $this->request->post['paystar_sort_order'] : $this->config->get('paystar_sort_order');
		$this->data['paystar_status'] = isset($this->request->post['paystar_status']) ? $this->request->post['paystar_status'] : $this->config->get('paystar_status');
		
		/* DataRows */
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		$this->data['token'] = $this->session->data['token'];
		
		/* Template */
		$this->template = 'payment/paystar.tpl';
		$this->children = array('common/header', 'common/footer');
		
		$this->response->setOutput($this->render());
	}
	
	private function validate() 
	{
		if (!$this->user->hasPermission('modify', 'payment/paystar')) 
			$this->error['warning'] = $this->language->get('error_permission'); 
			
		return !$this->error ? true : false;
	}
}
?>