<?php echo $header; ?>
<div id="content">
	<div class="breadcrumb">
		<?php foreach ($breadcrumbs as $breadcrumb) { ?>
		<?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a>
		<?php } ?>
	</div>
	<?php if ($error_warning) { ?>
		<div class="warning"><?php echo $error_warning; ?></div>
	<?php } ?>
	<div class="box">
		<div class="heading">
			<h1><img src="view/image/shipping.png" alt="" /> <?php echo $heading_title; ?></h1>
			<div class="buttons"><a onclick="$('#form').submit();" class="button"><span><?php echo $button_save; ?></span></a><a onclick="location='<?php echo $cancel; ?>';" class="button"><span><?php echo $button_cancel; ?></span></a></div>
		</div>
		<div class="content">
			<div id="tabs" class="htabs">
				<a href="#tab-general"><?php echo $tab_general; ?></a>
			</div>
			<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form">
				<div id="tab-general" class="page">
					<h2><?php echo $fields_configuration_1; ?></h2>
					<table class="form">
						<tr>
							<td><?php echo $entry_api_paystar; ?></td>
							<td><input type="text" name="api_paystar" value="<?php echo $api_paystar; ?>" size="25" /></td>
						</tr>
						<tr>
							<td><?php echo $entry_bank_paystar; ?></td>
							<td>
								<select name="paystar_bank">
									<?php foreach($entry_bconfig_paystar as $k=>$v): ?>
									<option value="<?php echo $k; ?>" <?php echo ($paystar_bank == $k) ? 'selected="selected"' : ''; ?>><?php echo $v; ?></option>
									<?php endforeach; ?>
								</select>
							</td>
						</tr>							
					</table>
					
					<h2><?php echo $fields_configuration_2; ?></h2>
					<table class="form">
						<tr>
							<td><?php echo $entry_order_status; ?></td>
							<td>
								<select name="paystar_order_status_id">
									<?php foreach ($order_statuses as $order_status) { ?>
										<option value="<?php echo $order_status['order_status_id']; ?>" <?php echo $order_status['order_status_id'] == $paystar_order_status_id ? 'selected="selected"' : '' ?>><?php echo $order_status['name']; ?></option>
									<?php } ?>
								</select>
							</td>
						</tr>
						<tr>
							<td><?php echo $entry_status; ?></td>
							<td>
								<select name="paystar_status">
									<option value="1" <?php echo $paystar_status ? 'selected="selected"' : ''; ?>><?php echo $text_enabled; ?></option>
									<option value="0" <?php echo !$paystar_status  ? 'selected="selected"' : ''; ?>><?php echo $text_disabled; ?></option>
								</select>
							</td>
						</tr>
						<tr>
							<td><?php echo $entry_sort_order; ?></td>
							<td><input type="text" name="paystar_sort_order" value="<?php echo $paystar_sort_order; ?>" size="1" /></td>
						</tr>
						<tr>
							<td><?php echo $paystar_copyright_a; ?> : </td>
							<td><a href="https://paystar.ir" target="_blank" title="paystar.ir"><?php echo $paystar_copyright_b; ?></a></td>
						</tr>						
					</table>
				</div>
			</form>
		</div>
	</div>
</div>
​
<script type="text/javascript">
<!--
	$('#tabs a').tabs(); 
//-->
</script>

<?php echo $footer; ?> 