<?php
class ControllerPaymentPaystar extends Controller 
{
	private $WebService = array();
	private $errors = array();
	
	public function index() 
	{
		$this->language->load('payment/paystar');
		
		$this->data['text_wait'] = $this->language->get('text_wait');
		$this->data['button_confirm'] = $this->language->get('button_confirm');
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/paystar_checkout.tpl')) 
			$this->template = $this->config->get('config_template') . '/template/payment/paystar_checkout.tpl';
		else 
			$this->template = 'default/template/payment/paystar_checkout.tpl';	
	
		$this->render();
	}
	
	public function action() 
	{
		require(dirname(__FILE__) . '/../../../paystarconfig.php');
		$this->language->load('payment/paystar');
		
		$this->load->library('encryption');
		$encryption = new Encryption($this->config->get('config_encryption'));
		
		$json = array();
		$data = array();
		
		$order_id = isset($this->session->data['order_id']) ? $this->session->data['order_id'] : 0;
		
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($order_id);
		
		if ($order_info) 
		{
			$data['address_confirm'] = $this->url->link('payment/paystar/callback&id=' . $encryption->encrypt($order_id), 'SSL');
			$data['orderTotal']   = $this->currency->format($order_info['total'], $order_info['currency_code'], false, false);
			$data['orderTotal']   = $this->currency->convert($data['orderTotal'], $order_info['currency_code'], "TOM");
			$data['orderId'] 	  = $order_info['order_id'];
			$data['comment'] 	  = !empty($order_info['comment']) ? "توضیحات کاربر : {$order_info['comment']}" : 'توضیحاتی کاربر وارد نکرده است .';
				
			try 
			{
				$f = array(
					'amount' => $data['orderTotal'],
					'pin' => $this->config->get('api_paystar'),
					'callback' => $data['address_confirm'],
					'bank' => $this->config->get('paystar_bank'),
					'description' => "نام و نام خانوادگی : {$order_info['shipping_firstname']} {$order_info['shipping_lastname']}
	شماره موبایل : {$order_info['telephone']}
	ایمیل :‌ {$order_info['email']}
	شماره سفارش فروشگاه : {$order_info['order_id']} 
	{$data['comment']}"
				);

				$f_ = '';
				foreach($f as $k=>$v) 
					$f_ .= $k . '=' . urlencode($v) . '&'; 
					
				rtrim($f_, '&');

				$ch = curl_init();
				curl_setopt($ch,CURLOPT_URL, "https://{$ws_config['address']}/api/create/");
				curl_setopt($ch,CURLOPT_POST, count($f));
				curl_setopt($ch,CURLOPT_POSTFIELDS, $f_);
				curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
				$res = curl_exec($ch);
				curl_close($ch);
				if (!$res) 
					$json['error'] = 'ارتباط با بانک برقرار نشده است .';
				else 
				{
					if(strlen($res) > 5)
						$json['success'] = "https://{$ws_config['address']}/paying/{$res}";
					else
						$json['error'] = $res;				
				}
			}
			catch (Exception $e) 
			{
				$json['error'] = 'ارتباط با بانک برقرار نشده است .';
			} 			
		} 	
		else
		{
			$json['error'] = $this->language->get('error_order_id');
		}		
		$this->response->setOutput(json_encode($json));
	}
	
	public function callback() 
	{
		require(dirname(__FILE__) . '/../../../paystarconfig.php');
		$this->language->load('payment/paystar');
		
		$this->document->setTitle($this->language->get('text_heading'));
		
		$this->data['text_wait'] = $this->language->get('text_wait');
		$this->data['text_heading'] = $this->language->get('text_heading');
		$this->data['text_results'] = $this->language->get('text_results');
		
		$this->data['button_confirm'] = $this->language->get('button_confirm');
		$this->data['button_continue'] = $this->language->get('button_continue');
		
		$this->data['breadcrumbs'] = array();
      	$this->data['breadcrumbs'][] = array('text' => $this->language->get('text_home'), 'href' => $this->url->link('common/home', '', 'SSL'), 'separator' => false);
      	$this->data['breadcrumbs'][] = array('text' => $this->language->get('text_heading'), 'href' => $this->url->link('payment/paystar/callback', '', 'SSL'), 'separator' => $this->language->get('text_separator'));
		
		$this->data['error_warning'] = '';
		
		$this->load->library('encryption');
		$encryption = new Encryption($this->config->get('config_encryption'));
		
		$data = array();
		$data['address_cancel'] = $this->url->link('checkout/checkout', '', 'SSL');
		$data['address_success'] = $this->url->link('checkout/success', '', 'SSL');
		
		
		$order_id = isset($this->request->get['id']) ? $encryption->decrypt($this->request->get['id']) : 0;
		
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($order_id);
		
		if ($order_info) 
		{			
			$data['orderTotal'] = $this->currency->format($order_info['total'], $order_info['currency_code'], false, false);
			$data['orderTotal'] = $this->currency->convert($data['orderTotal'], $order_info['currency_code'], "TOM");
			$data['orderId'] 	  = $order_info['order_id'];
			
			$data['authority'] = isset($this->request->post['transid']) ? $this->request->post['transid'] : false;
			if($data['authority'])
			{
				try
				{
					$f = array(
						'amount' => $data['orderTotal'],
						'pin' => $this->config->get('api_paystar'),
						'transid' => $data['authority'],
					);
					
					$f_ = '';
					foreach($f as $k=>$v) 
						$f_ .= $k . '=' . urlencode($v) . '&'; 
						
					rtrim($f_, '&');

					$ch = curl_init();
					curl_setopt($ch,CURLOPT_URL, "https://{$ws_config['address']}/api/verify/");
					curl_setopt($ch,CURLOPT_POST, count($f));
					curl_setopt($ch,CURLOPT_POSTFIELDS, $f_);
					curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
					$this->data['result'] = curl_exec($ch);
					curl_close($ch);
				}
				catch(Exception $e) 
				{
					$this->data['result'] = 'ارتباط با بانک برقرار نشده است .';
				}
					
				if(empty($this->data['result']))
					$this->data['error_warning'] = 'تراکنش پرداخت نشده است .';
				else if($this->data['result'] == 1)
					$this->data['authority'] = $data['authority'];					
				else
					$this->data['error_warning'] = $this->data['result'];
			}
			else
				$this->data['error_warning'] = -8;

			
			if ($this->data['error_warning']) 
				$this->data['continue'] = $data['address_cancel'];
			else
			{
				$this->model_checkout_order->confirm($order_info['order_id'], $this->config->get('paystar_order_status_id'), $this->data['text_results'] . ' ' . $this->data['authority'], true);
				$this->data['continue'] = $data['address_success'];
			}		
		} 
		else 
		{
			$this->data['error_warning'] = $this->language->get('error_order_id');
			$this->data['continue'] = $data['address_cancel'];
		}
	
		/* Template */
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/paystar_confirm.tpl')) 
			$this->template = $this->config->get('config_template') . '/template/payment/paystar_confirm.tpl';
		else 
			$this->template = 'default/template/payment/paystar_confirm.tpl';	
	
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'
		);
		
		$this->response->setOutput($this->render());
	}
	
	// Resources
	/*private function getError($errCode) 
	{
		switch($errCode) 
		{ 
			case '-20' : 
				$prompt = "api نامعتبر است"; break; 
			case '-21' : 
				$prompt = "آی پی نامعتبر است"; break; 
			case '-22' : 
				$prompt = "مبلغ از کف تعریف شده کمتر است"; break; 
			case '-23' : 
				$prompt = "مبلغ از سقف تعریف شده بیشتر است"; break; 
			case '-24' : 
				$prompt = "مبلغ نامعتبر است"; break; 
			case '-6' : 
				$prompt = "ارتباط با بانک برقرار نشد"; break; 
			case '-26' : 
				$prompt = "درگاه غیرفعال است"; break; 
			case '-27' :			
				$prompt = "آی پی شما مسدود است"; break; 
			case '-9' : 
				$prompt = "خطای ناشناخته"; break; 
			case '-29' :			
				$prompt = "آدرس کال بک خالی است"; break; 
			case '-30' :			
				$prompt = "چنین تراکنشی یافت نشد"; break;
			case '-31' : 
				$prompt = "تراکنش انجام نشده"; break; 
			case '-32' : 
				$prompt = "تراکنش انجام شده اما مبلغ نادرست است"; break; 			
		}
		return 'خطا (' . $errCode . ') : ' . $prompt;	
	}*/
}
?>