<?php if (!defined('_PS_VERSION_')) exit;

class paystarpayment extends PaymentModule
{

	private $_html = '';
	private $_postErrors = array();

	public function __construct()
	{
		$this->name = 'paystarpayment';
		$this->tab = 'payments_gateways';
		$this->version = '1.9';
		$this->author = 'http://modulebank.ir';
		$this->currencies = true;
  		$this->currencies_mode = 'checkbox';
		parent::__construct();
		$this->page = basename(__FILE__, '.php');
		$this->displayName = 'درگاه پرداخت پی استار';
		$this->description = 'پرداخت از طریق درگاه پرداخت انلاین پی استار';
		$this->confirmUninstall = 'آیا مطمئن هستید می خواهید جزئیات را حذف کنید ؟';
		if (!sizeof(Currency::checkPaymentCurrencies($this->id)))
			$this->warning = 'لطفا واحد پولی درگاه را تنظیم نمایید';
		$config = Configuration::getMultiple(array('paystar_terminal', 'paystar_title', 'paystar_rate', ''));
		if (!isset($config['paystar_terminal'],$config['paystar_title'],$config['paystar_rate']))
			$this->warning = 'لطفا اطلاعات ترمینال درگاه را تنظیم نمایید';
	}

	public function install()
	{
		if (!parent::install() or !Configuration::updateValue('paystar_terminal', '') or !Configuration::updateValue('paystar_title', '') or !Configuration::updateValue('paystar_rate', '') or !$this->registerHook('payment') or !$this->registerHook('paymentReturn'))
		return false;
		return true;
	}

	public function uninstall()
	{
		if (!Configuration::deleteByName('paystar_terminal') or !Configuration::deleteByName('paystar_title') or !Configuration::deleteByName('paystar_rate') or !parent::uninstall())
		return false;
		return true;
	}

	public function displayFormSettings()
	{
		$this->_html .= '<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<legend><img src="../img/admin/cog.gif" alt="" class="middle" />تنظیمات</legend>
				<label> عنوان نمایشی درگاه پی استار </label>
				<div class="margin-form"><input type="text" size="30" name="paystar_title" id="paystar_title" value="'.Configuration::get('paystar_title').'" /></div>
				<label> ترمینال درگاه پی استار </label>
				<div class="margin-form"><input type="text" size="30" name="paystar_terminal" id="paystar_terminal" value="'.Configuration::get('paystar_terminal').'" /></div>
				<label> نرخ ارز </label>
				<div class="margin-form"><input type="number" min="0.01" step="0.01" size="30" name="paystar_rate" id="paystar_rate" value="'.(Configuration::get('paystar_rate')?:1).'" /></div>
				<p>برای مثال ؛ اگر محصولات سایت شما به ریال نمایش داده می شود ؛ برای واحد پولی ریال عدد 1 را وارد کنید . یا مثلا برای تومان عدد 10 را وارد کنید. یا برای دلار ، نرخ روز دلار را به ریال وارد کنید</p>
				<center><input type="submit" name="submit" value="ذخیره" class="button" /></center>
			</fieldset>
		</form>';
	}

	public function displayConf()
	{
		$this->_html .= '<div class="conf confirm"><img src="../img/admin/ok.gif" />تنظیمات بروز رسانی شد</div>';
	}

	public function displayErrors()
	{
		foreach ($this->_postErrors as $err)
		$this->_html .= '<div class="alert error">'. $err .'</div>';
	}

	public function getContent()
	{
		$this->displayPayStarPayment();
		$this->postprocess();
		$this->displayFormSettings();
		return $this->_html;
	}
	
	private function postprocess()
	{
		if (isset($_POST['submit']))
		{
			if (empty($_POST['paystar_terminal']))
				$this->_postErrors[] = 'ورود ترمینال درگاه پی استار الزامیست.';
			if (empty($_POST['paystar_title']))
				$this->_postErrors[] = 'ورود نام نمایشی درگاه پی استار الزامیست.';
			if (empty($_POST['paystar_rate']))
				$this->_postErrors[] = 'ورود نرم ارز درگاه پی استار الزامیست.';
			if (!sizeof($this->_postErrors))
			{
				Configuration::updateValue('paystar_terminal', $_POST['paystar_terminal']);
				Configuration::updateValue('paystar_title', $_POST['paystar_title']);
				Configuration::updateValue('paystar_rate', $_POST['paystar_rate']);
				return $this->displayConf();
			}
			return $this->displayErrors();
		}
	}

	private function displayPayStarPayment()
	{
		$this->_html .= '<h2>درگاه پرداخت پی استار</h2><img src="../modules/paystarpayment/logo.png" style="float:left; margin-right:15px;"><b>این افزونه به شما امکان پرداخت از طریق درگاه پرداخت انلاین پی استار را برای شما فراهم می کند.</b><br /><br />';
	}

	public function execPayment($cart)
	{
		global $cookie, $smarty;
		$amount = $cart->getOrderTotal(true, 3);
		$rate = Configuration::get('paystar_rate')?:1;
		if ($rate > 0)
		{
			$amount *= $rate;
		}
		$address  = new Address(intval($cart->id_address_invoice));
		$redirect = (Configuration::get('PS_SSL_ENABLED') ?'https://' :'http://').$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'modules/paystarpayment/validation.php?&ResNum='.$cart->id;
		require_once(dirname(__FILE__) . '/paystar_payment_helper.class.php');
		$p = new PayStar_Payment_Helper(Configuration::get('paystar_terminal'));
		$r = $p->paymentRequest(array(
				'amount'      => intval(ceil($amount)),
				'order_id'    => $cart->id,
				'name'        => @$address->firstname . ' ' . @$address->lastname,
				'phone'       => (@$address->phone_mobile?:'09121111111'),
				'mail'        => (@$customer->email?:'empty@mail.com'),
				'description' => 'PrestaShop-Order#'.$cart->id,
				'callback'    => $redirect,
			));
		if ($r)
		{
			setcookie("OrderId", $cart->id, time()+1800);
			$p->redirect();
			echo '<p>لطفاً صبر کنید ... <br /> در حال اتصال به بانک ...</p>';
		}
		else
		{
			echo 'خطا در اتصال به درگاه پی استار : ' . $p->error;
		}
	}

	public function confirmPayment($amount)
	{
		$rate = Configuration::get('paystar_rate')?:1;
		if ($rate > 0)
		{
			$amount *= $rate;
		}
		require_once(dirname(__FILE__) . '/paystar_payment_helper.class.php');
		$p = new PayStar_Payment_Helper(Configuration::get('paystar_terminal'));
		$r = $p->paymentVerify($x = array_merge($_POST, array('amount' => intval(ceil($amount)))));
		if ($r)
		{
			return array(true, $p->txn_id);
		}
		else
		{
			return array(false, 'خطا : '.$p->error);
		}
	}

	public function showMessages($result)
	{
		$this->_postErrors[] = $result;
		$this->displayErrors();
		echo $this->_html;
		return $result;
	}

	public function hookPayment($params)
	{
		if (!$this->active)
		return;
		return $this->display(__FILE__, 'payment.tpl');
	}

	public function hookPaymentReturn($params)
	{
		if (!$this->active)
		return;
		return $this->display(__FILE__, 'confirmation.tpl');
	}
}
