<?php

use PrestaShop\PrestaShop\Core\Payment\PaymentOption;

if (!defined('_PS_VERSION_')) exit;

class Paystar extends PaymentModule
{

	private $_html = '';
	private $_postErrors = array();

	public function __construct()
	{
		$this->name = 'paystar';
		$this->tab = 'payments_gateways';
		$this->version = '2.5';
		$this->author = 'http://modulebank.ir';
		$this->currencies = true;
  		$this->currencies_mode = 'checkbox';
  		$this->controllers = array('request', 'verify');
		parent::__construct();
		$this->page = basename(__FILE__, '.php');
		$this->displayName = 'درگاه پرداخت پی استار';
		$this->description = 'پرداخت از طریق درگاه پرداخت پی استار';
		$this->confirmUninstall = 'آیا مطمئن هستید می خواهید جزئیات را حذف کنید ؟';
		$this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
		if (!sizeof(Currency::checkPaymentCurrencies($this->id)))
			$this->warning = 'لطفا واحد پولی درگاه را تنظیم نمایید';
		$config = Configuration::getMultiple(array('paystar_terminal', 'paystar_title', 'paystar_rate', ''));
		if (!isset($config['paystar_terminal'],$config['paystar_title'],$config['paystar_rate']))
			$this->warning = 'لطفا اطلاعات ترمینال درگاه را تنظیم نمایید';
	}

	public function install()
	{
		if (!parent::install() or !Configuration::updateValue('paystar_terminal', '') or !Configuration::updateValue('paystar_title', '') or !Configuration::updateValue('paystar_rate', '') or !$this->registerHook('paymentOptions') or !$this->registerHook('paymentReturn'))
		return false;
		return true;
	}

	public function uninstall()
	{
		if (!Configuration::deleteByName('paystar_terminal') or !Configuration::deleteByName('paystar_title') or !Configuration::deleteByName('paystar_rate') or !parent::uninstall())
		return false;
		return true;
	}

	public function displayFormSettings()
	{
		$this->_html .= '<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<legend>تنظیمات</legend>
				<label> عنوان نمایشی درگاه پی استار </label>
				<div class="margin-form"><input type="text" size="30" name="paystar_title" id="paystar_title" value="'.Configuration::get('paystar_title').'" /></div>
				<label> ترمینال درگاه پی استار </label>
				<div class="margin-form"><input type="text" size="30" name="paystar_terminal" id="paystar_terminal" value="'.Configuration::get('paystar_terminal').'" /></div>
				<label> نرخ ارز </label>
				<div class="margin-form"><input type="number" min="0.01" step="0.01" size="30" name="paystar_rate" id="paystar_rate" value="'.(Configuration::get('paystar_rate')?:1).'" /></div>
				<center><input type="submit" name="submit" value="ذخیره" class="button" /></center>
			</fieldset>
		</form>';
	}

	public function displayConf()
	{
		$this->_html .= '<div class="conf confirm">تنظیمات بروز رسانی شد</div>';
	}

	public function displayErrors()
	{
		foreach ($this->_postErrors as $err)
		$this->_html .= '<div class="alert error">'. $err .'</div>';
	}

	public function getContent()
	{
		$this->displayPayStar();
		$this->postprocess();
		$this->displayFormSettings();
		return $this->_html;
	}
	
	private function postprocess()
	{
		if (isset($_POST['submit']))
		{
			if (empty($_POST['paystar_terminal']))
				$this->_postErrors[] = 'ورود ترمینال درگاه پی استار الزامیست.';
			if (empty($_POST['paystar_title']))
				$this->_postErrors[] = 'ورود نام نمایشی درگاه پی استار الزامیست.';
			if (empty($_POST['paystar_rate']))
				$this->_postErrors[] = 'ورود نرخ ارز درگاه پی استار الزامیست.';
			if (!sizeof($this->_postErrors))
			{
				Configuration::updateValue('paystar_terminal', $_POST['paystar_terminal']);
				Configuration::updateValue('paystar_title', $_POST['paystar_title']);
				Configuration::updateValue('paystar_rate', $_POST['paystar_rate']);
				return $this->displayConf();
			}
			return $this->displayErrors();
		}
	}

	private function displayPayStar()
	{
		$this->_html .= '<h2>درگاه پرداخت پی استار</h2><img src="../modules/paystar/logo.png" style="float:left; margin-right:15px;"><b>این افزونه امکان پرداخت از طریق درگاه پرداخت پی استار را برای شما فراهم می کند.</b><br /><br />';
	}

	public function execPayment($cart)
	{
		global $cookie, $smarty;
		$amount = $cart->getOrderTotal(true, Cart::BOTH);
		$rate = Configuration::get('paystar_rate')?:1;
		if ($rate > 0) $amount *= $rate;
		$address  = new Address(intval($cart->id_address_invoice));
		require_once(dirname(__FILE__) . '/paystar_payment_helper.class.php');
		$p = new PayStar_Payment_Helper(Configuration::get('paystar_terminal'));
		$r = $p->paymentRequest(array(
				'amount'   => intval(ceil($amount)),
				'order_id' => $cart->id,
				'phone'    => @$address->phone_mobile,
				'callback' => $this->context->link->getModuleLink($this->name, 'verify', array('ResNum' => $cart->id), true)
			));
		if ($r)
		{
			$p->redirect();
		}
		else
		{
			return 'خطا : ' . $p->error;
		}
	}

	public function confirmPayment($amount)
	{
		require_once(dirname(__FILE__) . '/paystar_payment_helper.class.php');
		$p = new PayStar_Payment_Helper(Configuration::get('paystar_terminal'));
		$rate = Configuration::get('paystar_rate')?:1;
		if ($rate > 0) $amount *= $rate;
		$r = $p->paymentVerify(array_merge($_POST, array('amount' => $amount)));
		if ($r)
		{
			return array(true, $p->txn_id);
		}
		else
		{
			return array(false, 'خطای استعلام پرداخت : '.$p->error);
		}
	}

	public function showMessages($result)
	{
		$this->_postErrors[] = $result;
		$this->displayErrors();
		echo $this->_html;
		return $result;
	}

	public function hookPaymentOptions($params)
	{
		if (!$this->active) return;
		//if (!$this->checkCurrency($params['cart'])) return;
		$cart = $this->context->cart;
		$total = Tools::displayPrice($cart->getOrderTotal(true, Cart::BOTH));
		$view = '<section><p class="payment_module"><img src="modules/paystar/logo.png" alt="'.Configuration::get('paystar_title').'" />'.Configuration::get('paystar_title').' <br /></p></section>';
		$newOption = new PaymentOption();
		$newOption->setModuleName($this->name)->setCallToActionText(Configuration::get('paystar_title'))->setAction($this->context->link->getModuleLink($this->name, 'request', array(), true))->setAdditionalInformation($view);
		return array($newOption);
	}

}
