<?php

class PaystarVerifyModuleFrontController extends ModuleFrontController
{

	public function postProcess()
	{
		$OrderId = $_POST['order_id'];
		$cart = $this->context->cart;
		$cart = new Cart(intval($OrderId));
		if ($cart->id_customer == 0 || $cart->id_address_delivery == 0 || $cart->id_address_invoice == 0 || !$this->module->active)
		{
			Tools::redirect('index.php?controller=order&step=1');
		}
		$customer = new Customer($cart->id_customer);
		if (!Validate::isLoadedObject($customer)) {
			Tools::redirect('index.php?controller=order&step=1');
		}
		$total = (float)$cart->getOrderTotal(true, Cart::BOTH);
		$result = $this->module->confirmPayment($total);
		if ($result[0] === true)
		{
			$this->module->validateOrder((int)$cart->id, _PS_OS_PAYMENT_, $total, $this->module->displayName, 'پرداخت با موفقیت انجام شد. شماره پیگیری : '.$result[1],array(), (int)$cart->id_currency, false, $customer->secure_key);
			if (!$customer->is_guest)
				Tools::redirect('history.php');
			$current = new Order($this->module->currentOrder);
			Tools::redirect('guest-tracking.php?order_reference='.$current->reference.'&email='.$customer->email);
			Tools::redirect('index.php?controller=order-confirmation&id_cart='.(int)$cart->id.'&id_module='.(int)$this->module->id.'&id_order='.$this->module->currentOrder.'&key='.$customer->secure_key);
		}
		else
		{
			$this->errors[] = $result[1];
			if ($customer->is_guest) {
				$url = Context::getContext()->link->getPageLink('guest-tracking', true);
			} else {
				$url = Context::getContext()->link->getPageLink('history', true);
			}
			$this->redirectWithNotifications($url);
		}
	}

}
