<?php
/**
 * Interface for a Sync Handler in Paystar Connect.
 *
 * Defines the contract for classes that can handle bulk synchronization for a
 * specific type of data (e.g., WooCommerce products, Gravity Forms).
 *
 * @package    Paystar_Connect
 * @subpackage Paystar_Connect/includes/interfaces
 * @author     Dinor Digital <info@dinordigital.ir>
 * @since      2.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

interface Paystar_Connect_Sync_Handler_Interface {

    /**
     * Gets the unique identifier for this handler.
     *
     * This ID is used internally to route AJAX requests and should be a unique
     * string, e.g., 'wc-products'.
     *
     * @return string The unique identifier for the handler.
     */
    public function get_id();

    /**
     * Gets the user-friendly name for this sync type.
     *
     * This name is displayed in the UI for the user to select.
     * e.g., 'WooCommerce Products'.
     *
     * @return string The user-friendly name.
     */
    public function get_name();

    /**
     * Retrieves a list of all item IDs that need to be synced.
     *
     * This method should return an array of IDs (e.g., post IDs, form IDs)
     * that will be processed in batches.
     *
     * @return array An array of item IDs.
     */
    public function get_all_item_ids();

    /**
     * Processes a single batch of item IDs.
     *
     * This method receives an array of item IDs and should handle the actual
     * synchronization logic for them (e.g., calling an API, updating meta).
     *
     * @param array $batch An array of item IDs to process.
     * @return array An array with the results of the batch processing,
     *               e.g., ['success' => true, 'processed_count' => 10].
     */
    public function process_batch( $batch );
}