( function( wp ) {
    // Simple registration (without JSX) - stop if the registry is not available.
    if ( ! window.wc || ! window.wc.wcBlocksRegistry || typeof window.wc.wcBlocksRegistry.registerPaymentMethod !== 'function' ) {
        return;
    }

    const registry = window.wc.wcBlocksRegistry;
    const el = wp.element.createElement;
    const { getSetting } = window.wc.wcSettings;

    // Read data sent from PHP. 'paystar_connect_data' is derived from the gateway name ($name).
    const settings = getSetting( 'paystar_connect_data', {} );

    // A simple component to display the gateway description.
    const Content = () => {
        const description = settings.description || '';
        return description ? el( 'p', null, description ) : null;
    };

    registry.registerPaymentMethod( {
        name: 'paystar_connect',
        // Dynamically read the title from settings.
        label: settings.title || 'Paystar Connect',
        content: el( Content, null ),
        edit: el( Content, null ),
        canMakePayment: () => true,
        ariaLabel: settings.title || 'Paystar Connect',
        supports: {
            // Also read the 'supports' value from settings.
            features: settings.supports || [ 'products' ],
        },
    } );
} )( window.wp );
