<?php
// File: integrations/woocommerce/class-wc-gateway-paystar-blocks.php

// If the Blocks class does not exist (older version or disabled), do not proceed.
if ( ! class_exists( 'Automattic\\WooCommerce\\Blocks\\Payments\\Integrations\\AbstractPaymentMethodType' ) ) {
    return;
}

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

/**
 * Paystar integration for WooCommerce Blocks (Checkout block).
 */
class WC_PayStar_Blocks extends AbstractPaymentMethodType {

    /**
     * Must be the same as $this->id in the WC_Gateway_PayStar class.
     */
    protected $name = 'paystar_connect';

    public function initialize() {
        // Settings stored in classic WooCommerce settings.
        $this->settings = get_option( 'woocommerce_paystar_connect_settings', [] );
    }

    public function is_active() {
        return filter_var( $this->get_setting( 'enabled', false ), FILTER_VALIDATE_BOOLEAN );
    }

    /**
     * This method returns the IDs of scripts that should be loaded on the Checkout Block page.
     * We are creating a simple JS file (without npm).
     */
    public function get_payment_method_script_handles() {
        $handle = 'wc-paystar-blocks';
        if ( ! wp_script_is( $handle, 'registered' ) ) {
            // Use the plugin path constant if defined; otherwise, use plugin_dir_url.
            $script_url = defined( 'PAYSTAR_CONNECT_URL' )
                ? PAYSTAR_CONNECT_URL . 'integrations/woocommerce/assets/js/blocks-paystar.js'
                : plugin_dir_url( dirname( __DIR__, 2 ) ) . 'integrations/woocommerce/assets/js/blocks-paystar.js';

            wp_register_script(
                $handle,
                $script_url,
                array( 'wc-blocks-registry', 'wp-element' ),
                PAYSTAR_CONNECT_VERSION,
                true
            );
        }
        return array( $handle );
    }

    /**
     * Returns an array of script handles to be enqueued for the admin.
     *
     * @return array
     */
    public function get_payment_method_script_handles_for_admin() {
        return $this->get_payment_method_script_handles();
    }

    /**
     * Data to be transferred to the frontend (optional).
     */
    public function get_payment_method_data() {
        return [
            'title'       => $this->get_setting( 'title' ),
            'description' => $this->get_setting( 'description' ),
            'supports'    => [ 'products' ],
        ];
    }
}
