<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * When the plugin is uninstalled, this code is executed to remove the main
 * settings option from the database, ensuring a clean removal.
 *
 * @link       https://paystar.ir
 * @since      0.1.0
 * @package    Paystar_Connect
 */

// If uninstall is not called from WordPress, exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Ensure the user has initiated the uninstall from within WordPress.
// This is a security measure to prevent direct access to the file.

// Delete the main settings option from the wp_options table.
// This removes the configuration data saved by the plugin.
delete_option( 'paystar_connect_settings' );

// Note for future development:
// If integrations (like WooCommerce or Gravity Forms) were to add their own
// specific options or transients, the cleanup logic for those would be added here.
// For example:
// delete_option( 'paystar_woocommerce_settings' );
// delete_transient( 'paystar_some_cached_data' );