<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://paystar.ir
 * @since             0.1.0
 * @package           Paystar_Connect
 *
 * @wordpress-plugin
 * Plugin Name:       Paystar Connect
 * Plugin URI:        https://dinordigital.ir/paystar-connect
 * Description:       درگاه یکپارچه پی‌استار برای وردپرس
 * Version:           2.12.1
 * Author:            دینور دیجیتال
 * Author URI:        https://dinordigital.ir
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       paystar-connect
 * Domain Path:       /languages
 * WC requires at least: 8.3
 * WC tested up to: 10.0
 */


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define plugin constants for easy access to paths and version.
define( 'PAYSTAR_CONNECT_VERSION', '2.12.1' );
define( 'PAYSTAR_CONNECT_PATH', plugin_dir_path( __FILE__ ) );
define( 'PAYSTAR_CONNECT_URL', plugin_dir_url( __FILE__ ) );

/**
 * ===================================================================
 * Load Dependencies First!
 * This ensures helper functions are available globally for all parts of the plugin.
 * ===================================================================
 */
require_once PAYSTAR_CONNECT_PATH . 'includes/functions.php';

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require_once PAYSTAR_CONNECT_PATH . 'includes/class-paystar-connect.php';

/**
 * ===================================================================
 * Time-Sensitive Gravity Forms Currency Registration
 *
 * This must be loaded here, outside of any hooks, to ensure it runs
 * before any other plugin or theme can trigger a currency check.
 * This is the definitive solution to the currency race condition.
 * ===================================================================
 */
// Conditionally load the Gravity Forms integration functions only if the base class exists.
if ( class_exists( 'GFCommon' ) ) {
	require_once PAYSTAR_CONNECT_PATH . 'integrations/gravity-forms/functions.php';
}


/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-paystar-connect-activator.php
 * @since 0.1.0
 */
function activate_paystar_connect() {
	require_once PAYSTAR_CONNECT_PATH . 'includes/class-paystar-connect-activator.php';
	PayStar_Connect_Activator::activate();
}
register_activation_hook( __FILE__, 'activate_paystar_connect' );

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-paystar-connect-deactivator.php
 * @since 0.1.0
 */
function deactivate_paystar_connect() {
	require_once PAYSTAR_CONNECT_PATH . 'includes/class-paystar-connect-deactivator.php';
	PayStar_Connect_Deactivator::deactivate();
}
register_deactivation_hook( __FILE__, 'deactivate_paystar_connect' );


/**
 * Add a "Settings" link to the plugin's action links on the plugins page.
 *
 * This provides a convenient shortcut for users to access the plugin's
 * main settings page directly from the plugins list table.
 *
 * @since  0.2.0
 * @param  array $links The existing action links for the plugin.
 * @return array The modified action links with the new "Settings" link.
 */
function paystar_connect_add_settings_link( $links ) {
	// Create the settings link markup.
	$settings_link = sprintf(
		'<a href="%s">%s</a>',
		esc_url( admin_url( 'admin.php?page=paystar-connect-settings' ) ),
		esc_html__( 'تنظیمات', 'paystar-connect' )
	);
	// Add the new link to the beginning of the links array.
	array_unshift( $links, $settings_link );
	return $links;
}
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'paystar_connect_add_settings_link' );

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since 0.1.0
 */
function run_paystar_connect() {
	// Instantiate the main plugin class.
	$plugin = new PayStar_Connect();
	// Execute the plugin's run method to hook everything into WordPress.
	$plugin->run();
}

// Fire it up!
run_paystar_connect();

