jQuery(document).ready(function($) {
    $('#starshop-manual-sync-button').on('click', function() {
        var button = $(this);
        var post_id = $('#post_ID').val();
        var nonce = $('#starshop_manual_sync_nonce').val();
        var original_text = button.text();
        var status_container = button.parent();

        button.text('Syncing...').prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'starshop_manual_sync',
                post_id: post_id,
                nonce: nonce
            },
            success: function(response) {
                if (response.success) {
                    status_container.find('p').first().html('✅ این محصول با فروشگاه‌ساز همگام‌سازی شده است.<br><strong>شناسه یکتا:</strong> ' + response.data.starshop_id);
                    alert('Success: ' + response.data.message);
                } else {
                    alert('Error: ' + response.data.message);
                }
            },
            error: function() {
                alert('An unexpected error occurred.');
            },
            complete: function() {
                button.text(original_text).prop('disabled', false);
            }
        });
    });
});