jQuery(document).ready(function($) {
    var statusInterval;
    var currentRunId = null; // Variable to hold the current run ID
    var nonce = $('#starshop_bulk_sync_nonce_field').val();

    function toFaNumber(n) {
        if (typeof n === 'undefined') {
            return '۰';
        }
        try {
            return n.toLocaleString('fa-IR');
        } catch (e) {
            return String(n).replace(/\d/g, d => '۰۱۲۳۴۵۶۷۸۹'[d]);
        }
    }

    function updateSyncStatus() {
        if (!currentRunId) {
            return; // Don't check status if there's no active run
        }
        $.post(ajaxurl, {
            action: 'starshop_get_sync_status',
            nonce: nonce,
            run_id: currentRunId // Send the specific run ID for status check
        }).done(function(response) {
            if (response.success) {
                var total = response.data.total;
                var processed = response.data.processed;
                var created = response.data.created;
                var updated = response.data.updated;
                var errors = response.data.errors;
                var errorLogs = response.data.error_logs;
                var initialStart = response.data.initial_start;

                if (!initialStart || total === 0) {
                    resetSyncUI();
                    if (statusInterval) {
                        clearInterval(statusInterval);
                    }
                    return;
                }

                $('#start-bulk-sync').prop('disabled', true);
                $('#cancel-bulk-sync').show();
                $('#sync-progress-bar-container').show();
                $('#sync-status-text').attr('dir', 'rtl');

                var percentage = total > 0 ? Math.round((processed / total) * 100) : 0;
                
                var statusText = `پردازش شده: ${toFaNumber(processed)} از ${toFaNumber(total)} | ایجاد محصول: ${toFaNumber(created)} | بروزرسانی محصول: ${toFaNumber(updated)} | تعداد خطا: ${toFaNumber(errors)}`;
                var percentageText = `${toFaNumber(percentage)}٪`;

                $('#sync-progress-bar').css('width', percentage + '%');
                $('#sync-progress-bar-percentage').text(percentageText);
                $('#sync-status-text').html(statusText);

    if (errorLogs && errorLogs.length > 0) {
    	var $errorList = $('#sync-error-log-list');
    	var displayedErrors = $errorList.data('displayed-errors') || [];
    	$('#sync-error-log-container').show();
   
    	$.each(errorLogs, function(index, log) {
    		var uniqueKey = log.item_id + '-' + log.timestamp;
    		if (displayedErrors.indexOf(uniqueKey) === -1) {
    			var errorHtml = `
    				<div class="error">
    					<div class="error-head">
    						<p><strong>${log.title || 'خطا در همگام‌سازی'}</strong></p>
    						<p class="error-meta">${log.formatted_timestamp}</p>
    					</div>
    					<div class="content">
    						<div class="row">
    							<p class="key">علت بروز خطا</p>
    							<p class="value">${log.reason || log.message}</p>
    						</div>
    						<div class="row">
    							<p class="key">راه‌حل</p>
    							<p class="value">${log.solution || 'N/A'}</p>
    						</div>
    					</div>
    				</div>`;
    			$errorList.append(errorHtml);
    			displayedErrors.push(uniqueKey);
    		}
    	});
    	$errorList.data('displayed-errors', displayedErrors);
    } else {
    	$('#sync-error-log-container').hide();
    }

                if (response.data.pending === 0 && processed === total && total > 0) {
                    var finalText = `همگام‌سازی پایان یافت. | مجموع: ${toFaNumber(total)} | موفق: ${toFaNumber(created + updated)} | خطا: ${toFaNumber(errors)}`;
                    $('#sync-status-text').html(finalText);
                    $('#sync-progress-bar').css('width', '100%');
                    $('#sync-progress-bar-percentage').text('۱۰۰٪');
                    
                    $('#start-bulk-sync').prop('disabled', false);
                    $('#cancel-bulk-sync').hide();
                    
                    $.post(ajaxurl, { action: 'starshop_cancel_all_syncs', nonce: nonce });

                    if (statusInterval) {
                        clearInterval(statusInterval);
                    }
                }
            } else {
                resetSyncUI();
                if (statusInterval) {
                    clearInterval(statusInterval);
                }
            }
        }).fail(function() {
            $('#sync-status-text').text('خطا در بررسی وضعیت. لطفاً صفحه را رفرش کنید.');
            if (statusInterval) {
                clearInterval(statusInterval);
            }
        });
    }

    function resetSyncUI() {
        $('#start-bulk-sync').prop('disabled', false);
        $('#cancel-bulk-sync').hide();
        $('#sync-progress-bar-container').hide();
        $('#sync-progress-bar').css('width', '0%');
        $('#sync-progress-bar-percentage').text('');
        $('#sync-status-text').text('').attr('dir', 'rtl');
       $('#sync-error-log-container').hide();
       $('#sync-error-log-list').empty().data('displayed-errors', []);
        currentRunId = null; // Reset run ID
    }

    $('#start-bulk-sync').on('click', function() {
        var button = $(this);
        var syncType = $('#sync-type-selector').val();

        if (!syncType) {
            alert('لطفاً یک نوع محتوا برای همگام‌سازی انتخاب کنید.');
            return;
        }

        button.prop('disabled', true);
        $('#cancel-bulk-sync').show();
        $('#sync-status-text').text('در حال زمان‌بندی موارد...').attr('dir', 'rtl');
        $('#sync-progress-bar-container').show();
        $('#sync-progress-bar').css('width', '0%');
        $('#sync-progress-bar-percentage').text(toFaNumber(0) + '٪');

        $.post(ajaxurl, {
            action: 'starshop_schedule_bulk_sync',
            nonce: nonce,
            sync_type: syncType
        }).done(function(response) {
            if (response.success) {
                $('#sync-status-text').text(response.data.message);
                currentRunId = response.data.run_id; // Save the new run ID from the server
                if (statusInterval) {
                    clearInterval(statusInterval);
                }
                statusInterval = setInterval(updateSyncStatus, 5000);
                updateSyncStatus(); // Immediately check status
            } else {
                alert('خطا: ' + response.data.message);
                resetSyncUI();
            }
        }).fail(function() {
            alert('یک خطای اساسی رخ داد. لطفاً دوباره تلاش کنید.');
            resetSyncUI();
        });
    });

    $('#cancel-bulk-sync').on('click', function() {
        if (!confirm('آیا مطمئن هستید که می‌خواهید تمام کارهای همگام‌سازی در صف را لغو کنید؟')) {
            return;
        }
        $.post(ajaxurl, {
            action: 'starshop_cancel_all_syncs',
            nonce: nonce
        }).done(function(response) {
            if (response.success) {
                alert(response.data.message);
                resetSyncUI();
                if (statusInterval) {
                    clearInterval(statusInterval);
                }
            } else {
                alert('خطا در لغو همگام‌سازی.');
            }
        });
    });

    updateSyncStatus();
});