<?php
/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 * It is responsible for cleaning up the environment, such as flushing rewrite rules.
 *
 * @package    Paystar_Connect
 * @subpackage Paystar_Connect/includes
 * @author     Dinor Digital <info@dinordigital.ir>
 * @since      1.0.0
 */

// Exit if accessed directly for security.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
} 

class PayStar_Connect_Deactivator {

	/**
	 * The main deactivation method.
	 *
	 * This static method is called when the plugin is deactivated. It flushes
	 * the rewrite rules to ensure that any custom endpoints or URL structures
	 * added by the plugin are cleanly removed from the WordPress environment.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public static function deactivate() {
		// Flushing rewrite rules on deactivation is a best practice. It prevents
		// "404 Not Found" errors on pages or endpoints that the plugin created.
		flush_rewrite_rules();

		// Clear the scheduled event for API key refresh.
		wp_clear_scheduled_hook( 'paystar_connect_refresh_api_key_cron' );
	}
}