<?php
/**
 * General helper functions for the Paystar Connect plugin.
 *
 * This file contains globally available helper functions that can be used
 * throughout the plugin for common tasks.
 *
 * @package    Paystar_Connect
 * @subpackage Paystar_Connect/includes
 * @author     Dinor Digital <info@dinordigital.ir>
 * @since      1.0.0
 */

// Exit if accessed directly for security.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if (!function_exists('paystar_connect_get_amount_by_currency')) {
    /**
     * Converts amount to Rials if the currency is in Tomans.
     *
     * @param float  $amount The amount.
     * @param string $currency The currency code.
     * @return float The amount in Rials.
     */
    function paystar_connect_get_amount_by_currency($amount, $currency) {
        $toman_currencies = ['IRT', 'Toman', 'toman', 'تومان', 'تومان ایران'];
        if (in_array($currency, $toman_currencies, true)) {
            return (int) ($amount * 10);
        }
        return (int) $amount;
    }
}
