<?php defined( '_JEXEC' ) or die( 'Restricted access' );

class plgSystemRSFPPaystar extends JPlugin
{
	var $componentId 	= 864;
	var $componentValue = 'paystar';
	
	function plgSystemRSFPPaystar( &$subject, $config )
	{
		parent::__construct( $subject, $config );
		$this->newComponents = array(864);
	}
	
	function rsfp_bk_onAfterShowComponents()
	{		
		$lang = JFactory::getLanguage();
		$lang->load( 'plg_system_rsfppaystar' );
		$mainframe 	= JFactory::getApplication();
		$db 		= JFactory::getDBO();
		$formId 	= JRequest::getInt('formId');
		$link = "displayTemplate('".$this->componentId."')";
		if ($components = RSFormProHelper::componentExists($formId, $this->componentId))
			$link = "displayTemplate('".$this->componentId."', '".$components[0]."')";
		?>
		<li><a href="javascript: void(0);" onclick="<?php echo $link;?>;return false;" id="rsfpc<?php echo $this->componentId; ?>"><span id="paystar"><?php echo JText::_('RSFP_PAYSTAR_COMPONENT'); ?></span></a></li>
		<?php
	}
	
	function rsfp_getPayment(&$items, $formId)
	{
		if ($components = RSFormProHelper::componentExists($formId, $this->componentId))
		{
			$data = RSFormProHelper::getComponentProperties($components[0]);
			$item = new stdClass();
			$item->value = $this->componentValue;
			$item->text = $data['LABEL'];
			$items[] = $item;
		}
	}
	
	function rsfp_doPayment($payValue, $formId, $SubmissionId, $price, $products, $code)
	{
		if ($payValue != $this->componentValue) return;
		$mainframe = JFactory::getApplication();
		if ($price > 0)
		{
			require_once(dirname(__FILE__) . '/paystar_payment_helper.class.php');
			$p = new PayStar_Payment_Helper(RSFormProHelper::getConfig('paystar.terminal'));
			$r = $p->paymentRequest(array(
					'amount'   => intval(ceil($price)),
					'order_id' => time(),
					'callback' => JURI::root().'index.php?option=com_rsform&formId='.$formId.'&task=plugin&plugin_task=paystar.notify&code='.$code.'&amount='.$price
				));
			if ($r)
			{
				$p->redirect();
			}
			else
			{
				echo $p->error;
			}
			exit;
		}
	}
	
	function rsfp_bk_onAfterCreateComponentPreview($args = array())
	{
		if ($args['ComponentTypeName'] == 'paystar')
		{
			$args['out'] = '<td>&nbsp;</td>';
			$args['out'].= '<td>'.$args['data']['LABEL'].'</td>';	
		}
	}
	
	function rsfp_bk_onAfterShowConfigurationTabs($tabs)
	{
		$lang = JFactory::getLanguage();
		$lang->load( 'plg_system_rsfppaystar' );
		$tabs->addTitle(JText::_('RSFP_PAYSTAR_LABEL'), 'form-paystar');
		$tabs->addContent($this->paystarConfigurationScreen());
	}
	
	function rsfp_f_onSwitchTasks()
	{
		if (JRequest::getVar('plugin_task') == 'paystar.notify')
		{
			header('Content-Type: text/html; charset=utf-8');
			$formId = $_GET['formId'];
			$code = $_GET['code'];
			$price = $_GET['amount'];
			require_once(dirname(__FILE__) . '/paystar_payment_helper.class.php');
			$p = new PayStar_Payment_Helper(RSFormProHelper::getConfig('paystar.terminal'));
			$r = $p->paymentVerify(array_merge($_POST, array('amount' => $price)));
			if ($r)
			{
				$db = JFactory::getDBO();
				$db->setQuery("SELECT SubmissionId FROM #__rsform_submissions s WHERE s.FormId='".$formId."' AND MD5(CONCAT(s.SubmissionId,s.DateSubmitted)) = '".$db->escape($code)."'");
				if ($SubmissionId = $db->loadResult())
				{
					$db->setQuery("UPDATE #__rsform_submission_values sv SET sv.FieldValue=1 WHERE sv.FieldName='_STATUS' AND sv.FormId='".$formId."' AND sv.SubmissionId = '".$SubmissionId."'");
					$db->execute();
					$db->setQuery("UPDATE #__rsform_submission_values sv SET sv.FieldValue='".$p->txn_id."' WHERE sv.FieldName='tref' AND sv.FormId='".$formId."' AND sv.SubmissionId = '".$SubmissionId."'");
					$db->execute();
					$mainframe = JFactory::getApplication();
					$mainframe->triggerEvent('rsfp_afterConfirmPayment', array($SubmissionId));
				}
				echo ('<p style="font:bold 12px tahoma; color:#FF0000; direction:rtl; text-align:center;">پرداخت با موفقیت انجام شد.<br />شماره پیگیری : '.$p->txn_id.'<br /><a href="./?">برای ادامه کلیک کنید.</a></p>');
				echo ('<script>document.location="'.RSFormProHelper::getConfig('paystar.return').'";</script>');
				jexit('');
				exit;die;
			}
			else
			{
				echo ('<p style="font:bold 12px tahoma; color:#FF0000; direction:rtl; text-align:center;">پرداخت لغو شد.<br /><br />'.$p->error.'<br /><br /><a href="./?">برای ادامه کلیک کنید.</a></p>');
				echo ('<script>document.location="'.RSFormProHelper::getConfig('paystar.cancel').'";</script>');
				jexit('');
				exit;die;
			}
		}
	}
	
	function paystarConfigurationScreen()
	{
		ob_start();
		?>
		<div id="page-paystar" class="com-rsform-css-fix">
			<table  class="admintable">
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key"><label for="terminal"><?php echo JText::_( 'RSFP_PAYSTAR_TERMINAL' ); ?></label></td>
					<td><input type="text" name="rsformConfig[paystar.terminal]" value="<?php echo RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('paystar.terminal')); ?>" size="100" maxlength="64"></td>
				</tr>
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key"><label for="return"><?php echo JText::_( 'RSFP_PAYSTAR_RETURN' ); ?></label></td>
					<td><input type="text" name="rsformConfig[paystar.return]" value="<?php echo RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('paystar.return'));  ?>" size="100"></td>
				</tr>
				<tr>
					<td width="200" style="width: 200px;" align="right" class="key"><label for="cancel"><?php echo JText::_( 'RSFP_PAYSTAR_CANCEL' ); ?></label></td>
					<td><input type="text" name="rsformConfig[paystar.cancel]" value="<?php echo RSFormProHelper::htmlEscape(RSFormProHelper::getConfig('paystar.cancel'));  ?>" size="100"></td>
				</tr>
			</table>
		</div>
		<?php
		$contents = ob_get_contents();
		ob_end_clean();
		return $contents;
	}
}